/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.concurrent.atomic.AtomicLong;

@typeof(value="ms.lang.Resource")
public class CResource<T>
extends Construct {
    public static final CClassType TYPE = CClassType.get(CResource.class);
    private static final AtomicLong RESOURCE_POOL = new AtomicLong(0L);
    private final long id;
    private final T resource;
    private final ResourceToString toString;

    public CResource(T resource, Target t) {
        this(resource, new ResourceToString(){

            @Override
            public String getString(CResource id) {
                String original = id.getResource().getClass().getName() + "@" + Integer.toHexString(id.getResource().hashCode());
                String addendum = "";
                if (!original.equals(id.getResource().toString())) {
                    addendum = original + ":";
                }
                return "Resource@" + id.getId() + ":" + addendum + id.getResource().toString();
            }
        }, t);
    }

    public CResource(T resource, ResourceToString toString, Target t) {
        super("", Construct.ConstructType.RESOURCE, t);
        this.resource = resource;
        if (toString == null) {
            throw new NullPointerException();
        }
        this.toString = toString;
        this.id = RESOURCE_POOL.incrementAndGet();
    }

    public long getId() {
        return this.id;
    }

    public T getResource() {
        return this.resource;
    }

    @Override
    public String val() {
        return this.toString.getString(this);
    }

    @Override
    public String toString() {
        return this.val();
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public String docs() {
        return "A resource is a value that represents an underlying native object. The object cannot be accessed directly.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    public static interface ResourceToString {
        public String getString(CResource var1);
    }
}

