/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.environments;

import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.ExecutionQueue;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptExecutionQueue;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.IVariableList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.events.BoundEvent;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.StackTraceManager;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Iterator;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalEnv
implements Environment.EnvironmentImpl,
Cloneable {
    private ExecutionQueue executionQueue = null;
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    private final Map<String, Object> custom = new HashMap<String, Object>();
    private Script script = null;
    private final MutableObject<File> root;
    private final MutableObject<CClosure> uncaughtExceptionHandler = new MutableObject();
    private Map<String, Procedure> procs = null;
    private IVariableList iVariableList = null;
    private String label = null;
    private final EnumSet<RuntimeMode> runtimeModes;
    private boolean dynamicScriptingMode = false;
    private BoundEvent.ActiveEvent event = null;
    private boolean interrupt = false;
    private final List<Iterator> arrayAccessList = Collections.synchronizedList(new ArrayList());
    private final WeakHashMap<Thread, StackTraceManager> stackTraceManagers = new WeakHashMap();
    private final MutableObject<Map<String, Mixed>> runtimeSettings = new MutableObject(new ConcurrentHashMap());
    private FileOptions fileOptions;
    private boolean cloneVars = true;

    public GlobalEnv(ExecutionQueue queue, File root, EnumSet<RuntimeMode> runtimeModes) {
        Static.AssertNonNull(queue, "ExecutionQueue cannot be null");
        Static.AssertNonNull(root, "Root file cannot be null");
        RuntimeMode.validate(runtimeModes);
        this.executionQueue = queue;
        this.root = new MutableObject<File>(root);
        if (this.executionQueue instanceof MethodScriptExecutionQueue) {
            ((MethodScriptExecutionQueue)this.executionQueue).setEnvironment(this);
        }
        this.runtimeModes = runtimeModes;
    }

    public ExecutionQueue GetExecutionQueue() {
        return this.executionQueue;
    }

    public void SetFlag(String name, boolean value) {
        this.flags.put(name, value);
    }

    public Boolean GetFlag(String name) {
        if (!this.flags.containsKey(name)) {
            return null;
        }
        return this.flags.get(name);
    }

    public void ClearFlag(String name) {
        this.flags.remove(name);
    }

    public void SetScript(Script s) {
        this.script = s;
    }

    public Script GetScript() {
        return this.script;
    }

    public void SetCustom(String name, Object var) {
        if (!this.custom.containsKey("custom")) {
            this.custom.put("custom", new HashMap());
        }
        ((Map)this.custom.get("custom")).put(name, var);
    }

    public Object GetCustom(String name) {
        if (!this.custom.containsKey("custom")) {
            this.custom.put("custom", new HashMap());
        }
        return ((Map)this.custom.get("custom")).get(name);
    }

    @Override
    public Environment.EnvironmentImpl clone() throws CloneNotSupportedException {
        GlobalEnv clone = (GlobalEnv)super.clone();
        clone.procs = this.procs != null ? new HashMap<String, Procedure>(this.procs) : new HashMap<String, Procedure>();
        if (this.cloneVars && this.iVariableList != null) {
            clone.iVariableList = this.iVariableList.clone();
        } else if (!this.cloneVars) {
            clone.iVariableList = new IVariableList();
        }
        return clone;
    }

    public void setCloneVars(boolean set) {
        this.cloneVars = set;
    }

    public boolean getCloneVars() {
        return this.cloneVars;
    }

    public File GetRootFolder() {
        return this.root.getObject();
    }

    public void SetRootFolder(File file) {
        Static.AssertNonNull(file, "Root file cannot be null");
        if (file.isFile()) {
            throw new IllegalArgumentException("File provided to SetRootFolder must be a folder, not a file. (" + file.toString() + " was found.)");
        }
        this.root.setObject(file);
    }

    public void SetExceptionHandler(CClosure construct) {
        this.uncaughtExceptionHandler.setObject(construct);
    }

    public CClosure GetExceptionHandler() {
        return this.uncaughtExceptionHandler.getObject();
    }

    public Map<String, Procedure> GetProcs() {
        if (this.procs == null) {
            this.procs = new HashMap<String, Procedure>();
        }
        return this.procs;
    }

    public void SetProcs(Map<String, Procedure> procs) {
        this.procs = procs;
    }

    public IVariableList GetVarList() {
        if (this.iVariableList == null) {
            this.iVariableList = new IVariableList();
        }
        return this.iVariableList;
    }

    public void SetVarList(IVariableList varList) {
        this.iVariableList = varList;
    }

    public String GetLabel() {
        return this.label;
    }

    public void SetLabel(String label) {
        this.label = label;
    }

    public boolean inCmdlineMode() {
        return this.runtimeModes.contains((Object)RuntimeMode.CMDLINE);
    }

    public boolean inInterpreterMode() {
        return this.runtimeModes.contains((Object)RuntimeMode.INTERPRETER);
    }

    public void SetDynamicScriptingMode(boolean dynamicScriptingMode) {
        this.dynamicScriptingMode = dynamicScriptingMode;
    }

    public boolean GetDynamicScriptingMode() {
        return this.dynamicScriptingMode;
    }

    public void SetEvent(BoundEvent.ActiveEvent e) {
        this.event = e;
    }

    public BoundEvent.ActiveEvent GetEvent() {
        return this.event;
    }

    public synchronized void SetInterrupt(boolean interrupted) {
        this.interrupt = interrupted;
    }

    public synchronized boolean IsInterrupted() {
        return this.interrupt;
    }

    public List<Iterator> GetArrayAccessIterators() {
        return this.arrayAccessList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Iterator> GetArrayAccessIteratorsFor(ArrayAccess array2) {
        ArrayList<Iterator> list = new ArrayList<Iterator>();
        List<Iterator> list2 = this.arrayAccessList;
        synchronized (list2) {
            for (Iterator value : this.arrayAccessList) {
                if (value.underlyingArray() != array2) continue;
                list.add(value);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTraceManager GetStackTraceManager() {
        Thread currentThread = Thread.currentThread();
        WeakHashMap<Thread, StackTraceManager> weakHashMap = this.stackTraceManagers;
        synchronized (weakHashMap) {
            StackTraceManager manager = this.stackTraceManagers.get(currentThread);
            if (manager == null) {
                manager = new StackTraceManager();
                this.stackTraceManagers.put(currentThread, manager);
            }
            return manager;
        }
    }

    public Mixed GetRuntimeSetting(String name) {
        return this.runtimeSettings.getObject().get(name);
    }

    public Mixed GetRuntimeSetting(String name, Mixed defaultValue) {
        Mixed value = this.GetRuntimeSettingOrCNull(name, defaultValue);
        if (CNull.NULL.equals(value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean GetRuntimeSetting(String name, boolean defaultValue, Target t) {
        Mixed b = this.GetRuntimeSetting(name, CBoolean.get(defaultValue));
        try {
            return ArgumentValidation.getBooleanish(b, t);
        }
        catch (CRECastException ex) {
            MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Runtime setting \"" + name + "\" is not a boolean value, but was expected to be. The default value is being used instead.", t);
            return defaultValue;
        }
    }

    public Mixed GetRuntimeSettingOrCNull(String name, Mixed defaultValue) {
        if (this.runtimeSettings.getObject().containsKey(name)) {
            return this.runtimeSettings.getObject().get(name);
        }
        return defaultValue;
    }

    public void SetRuntimeSetting(String name, Mixed value) {
        if (value == null) {
            this.runtimeSettings.getObject().remove(name);
        } else {
            this.runtimeSettings.getObject().put(name, value);
        }
    }

    public void SetFileOptions(FileOptions options) {
        this.fileOptions = options;
    }

    public FileOptions GetFileOptions() {
        return this.fileOptions;
    }
}

