/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.AbstractCREException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;

public class ExampleScript {
    String description;
    String originalScript;
    ParseTree script;
    String output;
    StringBuilder playerOutput = null;
    String functionName = "Example";
    static AliasCore fakeCore;
    static boolean init;

    public ExampleScript(String description, String script) throws ConfigCompileException {
        this(StackTraceUtils.getCallingClass(), description, script, null, false);
    }

    public ExampleScript(String description, String script, boolean intentionalCompileError) throws ConfigCompileException {
        this(StackTraceUtils.getCallingClass(), description, script, null, intentionalCompileError);
    }

    public ExampleScript(String description, String script, String output) throws ConfigCompileException {
        this(StackTraceUtils.getCallingClass(), description, script, output, false);
    }

    private ExampleScript(Class source, String description, String script, String output, boolean intentionalCompileError) throws ConfigCompileException {
        Class c = source;
        if (Function.class.isAssignableFrom(c)) {
            this.functionName = ((Function)ReflectionUtils.instantiateUnsafe(c)).getName();
        }
        this.description = description;
        this.originalScript = script;
        String errorOutput = "Oops, something went wrong with this example.";
        String consoleErrorOutput = Static.MCToANSIColors(MCChatColor.RED.toString() + "Unintentional compile error in " + c.getEnclosingClass().getSimpleName() + ":" + this.functionName + "(): \"" + description + "\"\n" + (Object)((Object)MCChatColor.PLAIN_WHITE));
        try {
            Environment env = Static.GenerateStandaloneEnvironment();
            this.script = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, null, new File((OSUtils.GetOS() == OSUtils.OS.WINDOWS ? "C:\\" : "/") + "Examples/" + this.functionName + ".ms"), true), env, new HashSet<Class<? extends Environment.EnvironmentImpl>>(ClassDiscovery.getDefaultInstance().loadClassesThatExtend(Environment.EnvironmentImpl.class)));
            this.output = output;
        }
        catch (ConfigCompileException e) {
            if (intentionalCompileError) {
                this.output = "Causes compile error: " + e.getMessage();
            } else {
                this.output = errorOutput;
                System.out.println(consoleErrorOutput);
                System.out.println(e.getMessage());
            }
        }
        catch (ConfigCompileGroupException ex) {
            if (intentionalCompileError) {
                StringBuilder b = new StringBuilder();
                b.append("Causes compile errors:\n");
                for (ConfigCompileException e : ex.getList()) {
                    b.append(e.getMessage()).append("\n");
                }
                this.output = b.toString();
            } else {
                this.output = errorOutput;
                System.out.println(consoleErrorOutput);
                for (ConfigCompileException e : ex.getList()) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
            ex.printStackTrace(System.err);
        }
        this.playerOutput = new StringBuilder();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAutomatic() {
        return this.output == null;
    }

    private Object genericReturn(Class r) {
        if (r.isPrimitive()) {
            if (r == Integer.TYPE) {
                return 0;
            }
            if (r == Byte.TYPE) {
                return (byte)0;
            }
            if (r == Double.TYPE) {
                return 0.0;
            }
            if (r == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (r == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (r == Short.TYPE) {
                return (short)0;
            }
            if (r == Boolean.TYPE) {
                return false;
            }
            return 0L;
        }
        if (r == String.class) {
            return "";
        }
        return null;
    }

    public String getScript() {
        return this.originalScript;
    }

    public String getOutput() throws IOException, DataSourceException, URISyntaxException {
        Environment env;
        if (this.output != null) {
            return this.output;
        }
        Script s = Script.GenerateScript(this.script, "*");
        try {
            env = Static.GenerateStandaloneEnvironment();
            env = env.cloneAndAdd(new CommandHelperEnvironment());
        }
        catch (Profiles.InvalidProfileException ex) {
            throw new RuntimeException(ex);
        }
        Class[] interfaces = new Class[]{MCPlayer.class};
        MCPlayer p2 = (MCPlayer)Proxy.newProxyInstance(ExampleScript.class.getClassLoader(), interfaces, (proxy, method, args) -> {
            if (method.getName().equals("getName") || method.getName().equals("getDisplayName")) {
                return "Player";
            }
            if (method.getName().equals("sendMessage")) {
                this.playerOutput.append(args[0].toString()).append("\n");
            }
            if (method.getName().equals("isOnline")) {
                return true;
            }
            return this.genericReturn(method.getReturnType());
        });
        env.getEnv(CommandHelperEnvironment.class).SetPlayer(p2);
        StringBuilder finalOutput = new StringBuilder();
        String thrown = null;
        try {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            try {
                MethodScriptCompiler.execute(this.originalScript, new File("/" + this.functionName + ".ms"), true, env, env.getEnvClasses(), output1 -> {
                    if (output1 != null) {
                        finalOutput.append(output1);
                    }
                }, null, vars);
            }
            catch (ConfigCompileException | ConfigCompileGroupException abstractCompileException) {}
        }
        catch (ConfigRuntimeException e) {
            String name = e.getClass().getName();
            if (e instanceof AbstractCREException) {
                name = ((AbstractCREException)e).getName();
            }
            thrown = "\n(Throws " + name + ": " + e.getMessage() + ")";
        }
        String playerOut = this.playerOutput.toString().trim();
        String finalOut = finalOutput.toString().trim();
        String out = (playerOut.isEmpty() ? "" : playerOut) + (finalOut.isEmpty() || !playerOut.trim().isEmpty() ? "" : ":" + finalOut);
        if (thrown != null) {
            out = out + thrown;
        }
        return out;
    }

    static {
        init = false;
    }

    private class FakeCore
    extends AliasCore {
        public FakeCore() {
            super(null, null, null, null, null);
            this.autoIncludes = new ArrayList();
        }
    }
}

