/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.BaseConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class CircuitsConfiguration
extends BaseConfiguration {
    public boolean enableNetherstone;
    public boolean enablePumpkins;
    public boolean enableGlowStone;
    public int glowstoneOffBlock;
    public PipeSettings pipeSettings;
    public ICSettings icSettings;

    public CircuitsConfiguration(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
    }

    public void load() {
        this.enableNetherstone = this.getBoolean("redstone-netherstone", false);
        this.enablePumpkins = this.getBoolean("redstone-pumpkins", true);
        this.enableGlowStone = this.getBoolean("redstone-glowstone", false);
        this.glowstoneOffBlock = this.getInt("glowstone-off-material", 20);
        this.icSettings = new ICSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "redstone-ics"));
        this.pipeSettings = new PipeSettings(new BaseConfiguration.BaseConfigurationSection((BaseConfiguration)this, "Pipes"));
    }

    public class PipeSettings {
        public final boolean enabled;
        public final boolean diagonals;
        public final int insulator;

        private PipeSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
            this.diagonals = section.getBoolean("allow-diagonal", true);
            this.insulator = section.getInt("insulator-block", 35);
        }
    }

    public class ICSettings {
        public final boolean cache;
        public final boolean enabled;
        public final boolean shorthand;
        public final List<String> disabledICs;

        private ICSettings(BaseConfiguration.BaseConfigurationSection section) {
            this.enabled = section.getBoolean("enable", true);
            this.cache = section.getBoolean("cache", true);
            this.shorthand = CircuitsConfiguration.this.getBoolean("enable-shorthand", false);
            this.disabledICs = section.getStringList("disabled-ics", new ArrayList());
        }
    }
}

