/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.CircuitsConfiguration;
import com.sk89q.craftbook.ICConfiguration;
import com.sk89q.craftbook.LanguageManager;
import com.sk89q.craftbook.Mechanic;
import com.sk89q.craftbook.MechanicFactory;
import com.sk89q.craftbook.MechanicManager;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitMetrics;
import com.sk89q.craftbook.bukkit.MechanicClock;
import com.sk89q.craftbook.bukkit.MechanicListenerAdapter;
import com.sk89q.craftbook.bukkit.commands.CircuitCommands;
import com.sk89q.craftbook.circuits.GlowStone;
import com.sk89q.craftbook.circuits.JackOLantern;
import com.sk89q.craftbook.circuits.Netherrack;
import com.sk89q.craftbook.circuits.Pipes;
import com.sk89q.craftbook.gates.logic.AndGate;
import com.sk89q.craftbook.gates.logic.Clock;
import com.sk89q.craftbook.gates.logic.ClockDivider;
import com.sk89q.craftbook.gates.logic.ClockST;
import com.sk89q.craftbook.gates.logic.CombinationLock;
import com.sk89q.craftbook.gates.logic.Counter;
import com.sk89q.craftbook.gates.logic.Delayer;
import com.sk89q.craftbook.gates.logic.Dispatcher;
import com.sk89q.craftbook.gates.logic.DownCounter;
import com.sk89q.craftbook.gates.logic.EdgeTriggerDFlipFlop;
import com.sk89q.craftbook.gates.logic.FullAdder;
import com.sk89q.craftbook.gates.logic.FullSubtractor;
import com.sk89q.craftbook.gates.logic.HalfAdder;
import com.sk89q.craftbook.gates.logic.HalfSubtractor;
import com.sk89q.craftbook.gates.logic.InvertedRsNandLatch;
import com.sk89q.craftbook.gates.logic.Inverter;
import com.sk89q.craftbook.gates.logic.JkFlipFlop;
import com.sk89q.craftbook.gates.logic.LevelTriggeredDFlipFlop;
import com.sk89q.craftbook.gates.logic.LowDelayer;
import com.sk89q.craftbook.gates.logic.LowNotPulser;
import com.sk89q.craftbook.gates.logic.LowPulser;
import com.sk89q.craftbook.gates.logic.Marquee;
import com.sk89q.craftbook.gates.logic.MemoryAccess;
import com.sk89q.craftbook.gates.logic.MemorySetter;
import com.sk89q.craftbook.gates.logic.Monostable;
import com.sk89q.craftbook.gates.logic.Multiplexer;
import com.sk89q.craftbook.gates.logic.NandGate;
import com.sk89q.craftbook.gates.logic.NotDelayer;
import com.sk89q.craftbook.gates.logic.NotLowDelayer;
import com.sk89q.craftbook.gates.logic.NotPulser;
import com.sk89q.craftbook.gates.logic.Pulser;
import com.sk89q.craftbook.gates.logic.Random3Bit;
import com.sk89q.craftbook.gates.logic.Random5Bit;
import com.sk89q.craftbook.gates.logic.RandomBit;
import com.sk89q.craftbook.gates.logic.RandomBitST;
import com.sk89q.craftbook.gates.logic.RangedOutput;
import com.sk89q.craftbook.gates.logic.Repeater;
import com.sk89q.craftbook.gates.logic.RsNandLatch;
import com.sk89q.craftbook.gates.logic.RsNorFlipFlop;
import com.sk89q.craftbook.gates.logic.ToggleFlipFlop;
import com.sk89q.craftbook.gates.logic.XnorGate;
import com.sk89q.craftbook.gates.logic.XorGate;
import com.sk89q.craftbook.gates.world.blocks.BlockBreaker;
import com.sk89q.craftbook.gates.world.blocks.BlockBreakerST;
import com.sk89q.craftbook.gates.world.blocks.BlockLauncher;
import com.sk89q.craftbook.gates.world.blocks.BonemealTerraformer;
import com.sk89q.craftbook.gates.world.blocks.BonemealTerraformerST;
import com.sk89q.craftbook.gates.world.blocks.CombineHarvester;
import com.sk89q.craftbook.gates.world.blocks.CombineHarvesterST;
import com.sk89q.craftbook.gates.world.blocks.Cultivator;
import com.sk89q.craftbook.gates.world.blocks.CultivatorST;
import com.sk89q.craftbook.gates.world.blocks.FlexibleSetBlock;
import com.sk89q.craftbook.gates.world.blocks.Irrigator;
import com.sk89q.craftbook.gates.world.blocks.IrrigatorST;
import com.sk89q.craftbook.gates.world.blocks.LavaSensor;
import com.sk89q.craftbook.gates.world.blocks.LavaSensorST;
import com.sk89q.craftbook.gates.world.blocks.LiquidFlood;
import com.sk89q.craftbook.gates.world.blocks.LiquidFloodST;
import com.sk89q.craftbook.gates.world.blocks.MultipleSetBlock;
import com.sk89q.craftbook.gates.world.blocks.Planter;
import com.sk89q.craftbook.gates.world.blocks.PlanterST;
import com.sk89q.craftbook.gates.world.blocks.Pump;
import com.sk89q.craftbook.gates.world.blocks.PumpST;
import com.sk89q.craftbook.gates.world.blocks.SetBlockAbove;
import com.sk89q.craftbook.gates.world.blocks.SetBlockAboveChest;
import com.sk89q.craftbook.gates.world.blocks.SetBlockAboveChestST;
import com.sk89q.craftbook.gates.world.blocks.SetBlockAboveST;
import com.sk89q.craftbook.gates.world.blocks.SetBlockBelow;
import com.sk89q.craftbook.gates.world.blocks.SetBlockBelowChest;
import com.sk89q.craftbook.gates.world.blocks.SetBlockBelowChestST;
import com.sk89q.craftbook.gates.world.blocks.SetBlockBelowST;
import com.sk89q.craftbook.gates.world.blocks.SetBridge;
import com.sk89q.craftbook.gates.world.blocks.SetDoor;
import com.sk89q.craftbook.gates.world.blocks.Spigot;
import com.sk89q.craftbook.gates.world.blocks.WaterSensor;
import com.sk89q.craftbook.gates.world.blocks.WaterSensorST;
import com.sk89q.craftbook.gates.world.entity.AdvancedEntitySpawner;
import com.sk89q.craftbook.gates.world.entity.CreatureSpawner;
import com.sk89q.craftbook.gates.world.entity.EntityCannon;
import com.sk89q.craftbook.gates.world.entity.EntityCannonST;
import com.sk89q.craftbook.gates.world.entity.EntityTrap;
import com.sk89q.craftbook.gates.world.entity.EntityTrapST;
import com.sk89q.craftbook.gates.world.entity.TeleportReciever;
import com.sk89q.craftbook.gates.world.entity.TeleportRecieverST;
import com.sk89q.craftbook.gates.world.entity.TeleportTransmitter;
import com.sk89q.craftbook.gates.world.items.AutomaticCrafter;
import com.sk89q.craftbook.gates.world.items.AutomaticCrafterST;
import com.sk89q.craftbook.gates.world.items.ChestStocker;
import com.sk89q.craftbook.gates.world.items.ChestStockerST;
import com.sk89q.craftbook.gates.world.items.ContainerCollector;
import com.sk89q.craftbook.gates.world.items.ContainerCollectorST;
import com.sk89q.craftbook.gates.world.items.ContainerDispenser;
import com.sk89q.craftbook.gates.world.items.ContainerDispenserST;
import com.sk89q.craftbook.gates.world.items.ItemDispenser;
import com.sk89q.craftbook.gates.world.items.ItemFan;
import com.sk89q.craftbook.gates.world.items.ItemFanST;
import com.sk89q.craftbook.gates.world.items.Sorter;
import com.sk89q.craftbook.gates.world.items.SorterST;
import com.sk89q.craftbook.gates.world.miscellaneous.ArrowBarrage;
import com.sk89q.craftbook.gates.world.miscellaneous.ArrowShooter;
import com.sk89q.craftbook.gates.world.miscellaneous.FireBarrage;
import com.sk89q.craftbook.gates.world.miscellaneous.FireShooter;
import com.sk89q.craftbook.gates.world.miscellaneous.FlameThrower;
import com.sk89q.craftbook.gates.world.miscellaneous.LightningSummon;
import com.sk89q.craftbook.gates.world.miscellaneous.Melody;
import com.sk89q.craftbook.gates.world.miscellaneous.MessageSender;
import com.sk89q.craftbook.gates.world.miscellaneous.ParticleEffect;
import com.sk89q.craftbook.gates.world.miscellaneous.ParticleEffectST;
import com.sk89q.craftbook.gates.world.miscellaneous.PotionInducer;
import com.sk89q.craftbook.gates.world.miscellaneous.PotionInducerST;
import com.sk89q.craftbook.gates.world.miscellaneous.SoundEffect;
import com.sk89q.craftbook.gates.world.miscellaneous.TimedExplosion;
import com.sk89q.craftbook.gates.world.miscellaneous.Tune;
import com.sk89q.craftbook.gates.world.miscellaneous.WirelessReceiver;
import com.sk89q.craftbook.gates.world.miscellaneous.WirelessReceiverST;
import com.sk89q.craftbook.gates.world.miscellaneous.WirelessTransmitter;
import com.sk89q.craftbook.gates.world.sensors.BlockSensor;
import com.sk89q.craftbook.gates.world.sensors.BlockSensorST;
import com.sk89q.craftbook.gates.world.sensors.DaySensor;
import com.sk89q.craftbook.gates.world.sensors.DaySensorST;
import com.sk89q.craftbook.gates.world.sensors.EntitySensor;
import com.sk89q.craftbook.gates.world.sensors.EntitySensorST;
import com.sk89q.craftbook.gates.world.sensors.ItemNotSensor;
import com.sk89q.craftbook.gates.world.sensors.ItemNotSensorST;
import com.sk89q.craftbook.gates.world.sensors.ItemSensor;
import com.sk89q.craftbook.gates.world.sensors.ItemSensorST;
import com.sk89q.craftbook.gates.world.sensors.LightSensor;
import com.sk89q.craftbook.gates.world.sensors.LightSensorST;
import com.sk89q.craftbook.gates.world.sensors.MovementSensor;
import com.sk89q.craftbook.gates.world.sensors.MovementSensorST;
import com.sk89q.craftbook.gates.world.sensors.PlayerSensor;
import com.sk89q.craftbook.gates.world.sensors.PlayerSensorST;
import com.sk89q.craftbook.gates.world.sensors.PowerSensor;
import com.sk89q.craftbook.gates.world.sensors.PowerSensorST;
import com.sk89q.craftbook.gates.world.weather.RainSensor;
import com.sk89q.craftbook.gates.world.weather.RainSensorST;
import com.sk89q.craftbook.gates.world.weather.ServerTimeModulus;
import com.sk89q.craftbook.gates.world.weather.TStormSensor;
import com.sk89q.craftbook.gates.world.weather.TStormSensorST;
import com.sk89q.craftbook.gates.world.weather.TimeControl;
import com.sk89q.craftbook.gates.world.weather.TimeControlAdvanced;
import com.sk89q.craftbook.gates.world.weather.TimeFaker;
import com.sk89q.craftbook.gates.world.weather.TimeSet;
import com.sk89q.craftbook.gates.world.weather.TimeSetST;
import com.sk89q.craftbook.gates.world.weather.WeatherControl;
import com.sk89q.craftbook.gates.world.weather.WeatherControlAdvanced;
import com.sk89q.craftbook.gates.world.weather.WeatherFaker;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.ICManager;
import com.sk89q.craftbook.ic.ICMechanicFactory;
import com.sk89q.craftbook.ic.RegisteredICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.ic.families.Family3I3O;
import com.sk89q.craftbook.ic.families.Family3ISO;
import com.sk89q.craftbook.ic.families.FamilyAISO;
import com.sk89q.craftbook.ic.families.FamilySI3O;
import com.sk89q.craftbook.ic.families.FamilySI5O;
import com.sk89q.craftbook.ic.families.FamilySISO;
import com.sk89q.craftbook.ic.families.FamilyVIVO;
import com.sk89q.craftbook.plc.PlcFactory;
import com.sk89q.craftbook.plc.lang.Perlstone;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.wepif.PermissionsResolverManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircuitsPlugin
extends BaseBukkitPlugin {
    public static final ICFamily FAMILY_SISO = new FamilySISO();
    public static final ICFamily FAMILY_3ISO = new Family3ISO();
    public static final ICFamily FAMILY_SI3O = new FamilySI3O();
    public static final ICFamily FAMILY_AISO = new FamilyAISO();
    public static final ICFamily FAMILY_3I3O = new Family3I3O();
    public static final ICFamily FAMILY_VIVO = new FamilyVIVO();
    public static final ICFamily FAMILY_SI5O = new FamilySI5O();
    protected CircuitsConfiguration config;
    protected ICConfiguration icConfig;
    public ICManager icManager;
    private PermissionsResolverManager perms;
    private MechanicManager manager;
    private static CircuitsPlugin instance;
    public static Server server;
    public ICMechanicFactory icFactory;
    public Pipes.Factory pipeFactory;
    public File romFolder;
    public File midiFolder;

    public static CircuitsPlugin getInst() {
        return instance;
    }

    public void onEnable() {
        super.onEnable();
        instance = this;
        server = this.getServer();
        this.registerCommand(CircuitCommands.class);
        this.createDefaultConfiguration("config.yml", false);
        this.createDefaultConfiguration("ic-config.yml", false);
        this.createDefaultConfiguration("custom-ics.txt", false);
        this.config = new CircuitsConfiguration(this.getConfig(), this.getDataFolder());
        this.saveConfig();
        PermissionsResolverManager.initialize((Plugin)this);
        this.perms = PermissionsResolverManager.getInstance();
        this.manager = new MechanicManager((BaseBukkitPlugin)this);
        MechanicListenerAdapter adapter = new MechanicListenerAdapter((BaseBukkitPlugin)this);
        adapter.register(this.manager);
        this.midiFolder = new File(this.getDataFolder(), "midi/");
        if (!this.midiFolder.exists()) {
            this.midiFolder.mkdir();
        }
        this.romFolder = new File(this.getDataFolder(), "rom/");
        if (!this.romFolder.exists()) {
            this.romFolder.mkdir();
        }
        this.registerMechanics();
        this.registerEvents();
        this.languageManager = new LanguageManager((BaseBukkitPlugin)this);
        try {
            BukkitMetrics metrics = new BukkitMetrics((Plugin)this);
            BukkitMetrics.Graph graph = metrics.createGraph("Language");
            for (String lan : this.languageManager.getLanguages()) {
                graph.addPlotter(new BukkitMetrics.Plotter(lan){

                    public int getValue() {
                        return 1;
                    }
                });
            }
            metrics.start();
        }
        catch (Exception e) {
            this.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
    }

    private void registerMechanics() {
        if (this.config.icSettings.enabled) {
            this.registerICs();
            this.icConfig = new ICConfiguration((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "ic-config.yml")), this.getDataFolder());
            try {
                this.icConfig.cfg.save(new File(this.getDataFolder(), "ic-config.yml"));
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, "Could not save IC Config", ex);
            }
        }
        if (this.config.enableNetherstone) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new Netherrack.Factory());
        }
        if (this.config.enablePumpkins) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new JackOLantern.Factory(this));
        }
        if (this.config.enableGlowStone) {
            this.registerMechanic((MechanicFactory<? extends Mechanic>)new GlowStone.Factory(this));
        }
        if (this.config.icSettings.enabled) {
            this.icFactory = new ICMechanicFactory(this, this.icManager);
            this.registerMechanic((MechanicFactory<? extends Mechanic>)this.icFactory);
            this.setupSelfTriggered();
        }
        if (this.config.pipeSettings.enabled) {
            this.pipeFactory = new Pipes.Factory(this);
            this.registerMechanic((MechanicFactory<? extends Mechanic>)this.pipeFactory);
        }
    }

    private void registerICs() {
        Server server = this.getServer();
        this.icManager = new ICManager();
        ICFamily familySISO = FAMILY_SISO;
        ICFamily family3ISO = FAMILY_3ISO;
        ICFamily familySI3O = FAMILY_SI3O;
        ICFamily familyAISO = FAMILY_AISO;
        ICFamily family3I3O = FAMILY_3I3O;
        ICFamily familyVIVO = FAMILY_VIVO;
        ICFamily familySI5O = FAMILY_SI5O;
        this.registerIC("MC1000", "repeater", new Repeater.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1001", "inverter", new Inverter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1017", "re t flip", new ToggleFlipFlop.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1018", "fe t flip", new ToggleFlipFlop.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1020", "random bit", new RandomBit.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1025", "server time", new ServerTimeModulus.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1110", "transmitter", new WirelessTransmitter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1111", "receiver", new WirelessReceiver.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1112", "tele-out", new TeleportTransmitter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1113", "tele-in", new TeleportReciever.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1200", "spawner", new CreatureSpawner.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1201", "dispenser", new ItemDispenser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1202", "c dispense", new ContainerDispenser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1203", "strike", new LightningSummon.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1204", "trap", new EntityTrap.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1205", "set above", new SetBlockAbove.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1206", "set below", new SetBlockBelow.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1207", "flex set", new FlexibleSetBlock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1208", "mult set", new MultipleSetBlock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1209", "collector", new ContainerCollector.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1210", "emitter", new ParticleEffect.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1211", "set bridge", new SetBridge.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1212", "set door", new SetDoor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1213", "sound", new SoundEffect.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1215", "set a chest", new SetBlockAboveChest.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1216", "set b chest", new SetBlockBelowChest.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1217", "pot induce", new PotionInducer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1218", "block launch", new BlockLauncher.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1219", "auto craft", new AutomaticCrafter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1220", "a b break", new BlockBreaker.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC1221", "b b break", new BlockBreaker.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC1222", "liquid flood", new LiquidFlood.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1223", "terraform", new BonemealTerraformer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1224", "time bomb", new TimedExplosion.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1225", "pump", new Pump.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1226", "spigot", new Spigot.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1227", "avd spawner", new AdvancedEntitySpawner.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1228", "ent cannon", new EntityCannon.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1229", "sorter", new Sorter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1230", "sense day", new DaySensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1231", "t control", new TimeControl.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1232", "time set", new TimeSet.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1233", "item fan", new ItemFan.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1234", "planter", new Planter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1235", "cultivator", new Cultivator.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1236", "fake weather", new WeatherFaker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1237", "fake time", new TimeFaker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1238", "irrigate", new Irrigator.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1239", "harvester", new CombineHarvester.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1240", "shoot arrow", new ArrowShooter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1241", "shoot arrows", new ArrowBarrage.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1242", "stocker", new ChestStocker.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1250", "shoot fire", new FireShooter.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1251", "shoot fires", new FireBarrage.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1252", "flame thower", new FlameThrower.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1260", "sense water", new WaterSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1261", "sense lava", new LavaSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1262", "sense light", new LightSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1263", "sense block", new BlockSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1264", "sense item", new ItemSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1265", "inv sense item", new ItemNotSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1266", "sense power", new PowerSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1267", "sense move", new MovementSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1270", "melody", new Melody.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1271", "sense entity", new EntitySensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1272", "sense player", new PlayerSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1275", "tune", new Tune.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1420", "divide clock", new ClockDivider.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1421", "clock", new Clock.Factory(server), familySISO, familyAISO);
        this.registerIC("MC1510", "send message", new MessageSender.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2100", "delayer", new Delayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2101", "inv delayer", new NotDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2110", "fe delayer", new LowDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2111", "inv fe delayer", new NotLowDelayer.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2500", "pulser", new Pulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2501", "inv pulser", new NotPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2510", "fe pulser", new LowPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2511", "inv fe pulser", new LowNotPulser.Factory(server), familySISO, familyAISO);
        this.registerIC("MC2020", "random 3", new Random3Bit.Factory(server), familySI3O);
        this.registerIC("MC2999", "marquee", new Marquee.Factory(server), familySI3O);
        this.registerIC("MC3002", "and", new AndGate.Factory(server), family3ISO);
        this.registerIC("MC3003", "nand", new NandGate.Factory(server), family3ISO);
        this.registerIC("MC3020", "xor", new XorGate.Factory(server), family3ISO);
        this.registerIC("MC3021", "xnor", new XnorGate.Factory(server), family3ISO);
        this.registerIC("MC3030", "nor flip", new RsNorFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3031", "inv nand latch", new InvertedRsNandLatch.Factory(server), family3ISO);
        this.registerIC("MC3032", "jk flip", new JkFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3033", "nand latch", new RsNandLatch.Factory(server), family3ISO);
        this.registerIC("MC3034", "edge df flip", new EdgeTriggerDFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3036", "level df flip", new LevelTriggeredDFlipFlop.Factory(server), family3ISO);
        this.registerIC("MC3040", "multiplexer", new Multiplexer.Factory(server), family3ISO);
        this.registerIC("MC3050", "combo", new CombinationLock.Factory(server), family3ISO);
        this.registerIC("MC3101", "down counter", new DownCounter.Factory(server), family3ISO);
        this.registerIC("MC3102", "counter", new Counter.Factory(server), family3ISO);
        this.registerIC("MC3231", "t control adva", new TimeControlAdvanced.Factory(server), family3ISO);
        this.registerIC("MC3300", "ROM set", new MemorySetter.Factory(server), family3ISO);
        this.registerIC("MC3301", "ROM get", new MemoryAccess.Factory(server), familySI3O);
        this.registerIC("MC4000", "full adder", new FullAdder.Factory(server), family3I3O);
        this.registerIC("MC4010", "half adder", new HalfAdder.Factory(server), family3I3O);
        this.registerIC("MC4100", "full subtr", new FullSubtractor.Factory(server), family3I3O);
        this.registerIC("MC4110", "half subtr", new HalfSubtractor.Factory(server), family3I3O);
        this.registerIC("MC4200", "dispatcher", new Dispatcher.Factory(server), family3I3O);
        this.registerIC("MC6020", "random 5", new Random5Bit.Factory(server), familySI5O);
        this.registerIC("MC5000", "perlstone", PlcFactory.fromLang(server, new Perlstone(), false), familyVIVO);
        this.registerIC("MC5001", "perlstone 3i3o", PlcFactory.fromLang(server, new Perlstone(), false), family3I3O);
        this.registerIC("MC0020", "random 1 st", new RandomBitST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0111", "receiver st", new WirelessReceiverST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0113", "tele-in st", new TeleportRecieverST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0202", "c dispense st", new ContainerDispenserST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0204", "trap st", new EntityTrapST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0205", "set above st", new SetBlockAboveST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0206", "set below st", new SetBlockBelowST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0209", "collector st", new ContainerCollectorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0210", "emitter st", new ParticleEffectST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0215", "set a chest st", new SetBlockAboveChestST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0216", "set b chest st", new SetBlockBelowChestST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0217", "pot induce st", new PotionInducerST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0219", "auto craft st", new AutomaticCrafterST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0220", "a bl break st", new BlockBreakerST.Factory(server, false), familySISO, familyAISO);
        this.registerIC("MC0221", "b bl break st", new BlockBreakerST.Factory(server, true), familySISO, familyAISO);
        this.registerIC("MC0222", "liq flood st", new LiquidFloodST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0223", "terraform st", new BonemealTerraformerST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0225", "pump st", new PumpST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0228", "ent cannon st", new EntityCannonST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0229", "sorter st", new SorterST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0230", "sense day st", new DaySensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0232", "time set st", new TimeSetST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0233", "item fan st", new ItemFanST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0234", "planter st", new PlanterST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0235", "cultivator st", new CultivatorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0238", "irrigate st", new IrrigatorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0239", "harvester st", new CombineHarvesterST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0242", "stocker st", new ChestStockerST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0260", "sense water st", new WaterSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0261", "sense lava st", new LavaSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0262", "sense light st", new LightSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0263", "sense block st", new BlockSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0264", "sense item st", new ItemSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0265", "sense n item s", new ItemNotSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0266", "sense power st", new PowerSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0267", "sense move st", new MovementSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0270", "sense power st", new PowerSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0271", "sense entit st", new EntitySensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0272", "sense playe st", new PlayerSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0420", "clock st", new ClockST.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0421", "monostable", new Monostable.Factory(server), familySISO, familyAISO);
        this.registerIC("MC0500", "range output", new RangedOutput.Factory(server), familySISO, familyAISO);
        this.registerIC("MCX230", "rain sense", new RainSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MCX231", "storm sense", new TStormSensor.Factory(server), familySISO, familyAISO);
        this.registerIC("MCX233", "weather set", new WeatherControl.Factory(server), familySISO, familyAISO);
        this.registerIC("MCT233", "weather set ad", new WeatherControlAdvanced.Factory(server), family3ISO);
        this.registerIC("MCZ230", "rain sense st", new RainSensorST.Factory(server), familySISO, familyAISO);
        this.registerIC("MCZ231", "storm sense st", new TStormSensorST.Factory(server), familySISO, familyAISO);
    }

    private void setupSelfTriggered() {
        logger.info("CraftBook: Enumerating chunks for self-triggered components...");
        long start = System.currentTimeMillis();
        int numWorlds = 0;
        int numChunks = 0;
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                this.manager.enumerate(chunk);
                ++numChunks;
            }
            ++numWorlds;
        }
        long time = System.currentTimeMillis() - start;
        logger.info("CraftBook Circuits: " + numChunks + " chunk(s) for " + numWorlds + " world(s) processed " + "(" + Math.round((double)time / 1000.0 * 10.0) / 10L + "s elapsed)");
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new MechanicClock(this.manager), 0L, 2L);
    }

    protected void registerEvents() {
    }

    public CircuitsConfiguration getLocalConfiguration() {
        return this.config;
    }

    public ICConfiguration getICConfiguration() {
        return this.icConfig;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return this.perms;
    }

    public List<RegisteredICFactory> getICList() {
        ArrayList<RegisteredICFactory> ics = new ArrayList<RegisteredICFactory>();
        for (Map.Entry<String, RegisteredICFactory> e : this.icManager.registered.entrySet()) {
            ics.add(e.getValue());
        }
        return ics;
    }

    public boolean registerIC(String name, String longName, ICFactory factory, ICFamily ... families) {
        if (this.config.icSettings.disabledICs.contains(name)) {
            return false;
        }
        return this.icManager.register(name, longName, factory, families);
    }

    public void registerMechanic(MechanicFactory<? extends Mechanic> factory) {
        this.manager.register(factory);
    }

    protected void registerMechanic(MechanicFactory<? extends Mechanic>[] factories) {
        for (MechanicFactory<? extends Mechanic> aFactory : factories) {
            this.registerMechanic(aFactory);
        }
    }

    protected boolean unregisterMechanic(MechanicFactory<? extends Mechanic> factory) {
        return this.manager.unregister(factory);
    }

    protected boolean unregisterAllMechanics() {
        boolean ret = true;
        Iterator iterator = this.manager.factories.iterator();
        while (iterator.hasNext()) {
            if (this.unregisterMechanic((MechanicFactory<? extends Mechanic>)((MechanicFactory)iterator.next()))) continue;
            ret = false;
        }
        return ret;
    }

    public void generateICDocs(Player player, String id) {
        RegisteredICFactory ric = this.icManager.registered.get(id.toLowerCase());
        if (ric == null) {
            try {
                ric = this.icManager.registered.get(this.getSearchID(player, id));
                if (ric == null) {
                    player.sendMessage(ChatColor.RED + "Invalid IC!");
                    return;
                }
            }
            catch (Exception e) {
                player.sendMessage(ChatColor.RED + "Invalid IC!");
                return;
            }
        }
        try {
            IC ic = ric.getFactory().create(null);
            player.sendMessage("    ");
            player.sendMessage(ChatColor.BLUE + ic.getTitle() + " (" + ric.getId() + ") Documentation");
            if (this.getLocalConfiguration().icSettings.shorthand && ric.getShorthand() != null) {
                player.sendMessage(ChatColor.YELLOW + "Shorthand: =" + ric.getShorthand());
            }
            player.sendMessage(ChatColor.YELLOW + "Desc: " + ric.getFactory().getDescription());
            if (ric.getFactory().getLineHelp()[0] != null) {
                player.sendMessage(ChatColor.YELLOW + "Line 3: " + ric.getFactory().getLineHelp()[0]);
            } else {
                player.sendMessage(ChatColor.YELLOW + "Line 3: Blank.");
            }
            if (ric.getFactory().getLineHelp()[1] != null) {
                player.sendMessage(ChatColor.YELLOW + "Line 4: " + ric.getFactory().getLineHelp()[1]);
            } else {
                player.sendMessage(ChatColor.YELLOW + "Line 4: Blank.");
            }
            player.sendMessage(ChatColor.AQUA + "Wiki: " + "http://wiki.sk89q.com/wiki/CraftBook/" + ric.getId().toUpperCase());
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    public String getSearchID(Player p, String search) {
        ArrayList<String> icNameList = new ArrayList<String>();
        icNameList.addAll(this.icManager.registered.keySet());
        Collections.sort(icNameList);
        for (String ic : icNameList) {
            try {
                RegisteredICFactory ric = this.icManager.registered.get(ic);
                IC tic = ric.getFactory().create(null);
                if (search != null && !tic.getTitle().toLowerCase().contains(search.toLowerCase()) && !ric.getId().toLowerCase().contains(search.toLowerCase())) continue;
                return ic;
            }
            catch (Exception ignored) {
            }
        }
        return "";
    }

    public String[] generateICText(Player p, String search, char[] parameters) {
        ArrayList<String> icNameList = new ArrayList<String>();
        icNameList.addAll(this.icManager.registered.keySet());
        Collections.sort(icNameList);
        ArrayList<String> strings = new ArrayList<String>();
        boolean col = true;
        block2: for (String ic : icNameList) {
            try {
                ChatColor colour;
                RegisteredICFactory ric = this.icManager.registered.get(ic);
                IC tic = ric.getFactory().create(null);
                if (search != null && !tic.getTitle().toLowerCase().contains(search.toLowerCase()) && !ric.getId().toLowerCase().contains(search.toLowerCase())) continue;
                if (parameters != null) {
                    for (char c : parameters) {
                        if (c == 'r' && !(ric.getFactory() instanceof RestrictedIC) || c == 's' && ric.getFactory() instanceof RestrictedIC || c == 'b' && !ric.getFactory().getClass().getPackage().getName().endsWith("blocks") || c == 'i' && !ric.getFactory().getClass().getPackage().getName().endsWith("items") || c == 'e' && !ric.getFactory().getClass().getPackage().getName().endsWith("entity") || c == 'w' && !ric.getFactory().getClass().getPackage().getName().endsWith("weather") || c == 'l' && !ric.getFactory().getClass().getPackage().getName().endsWith("logic") || c == 'm' && !ric.getFactory().getClass().getPackage().getName().endsWith("miscellaneous") || c == 'c' && !ric.getFactory().getClass().getPackage().getName().endsWith("sensors")) continue block2;
                    }
                }
                col = !col;
                ChatColor chatColor = colour = col ? ChatColor.YELLOW : ChatColor.GOLD;
                if (ric.getFactory() instanceof RestrictedIC) {
                    if (!p.hasPermission("craftbook.ic.restricted." + ic.toLowerCase())) {
                        colour = col ? ChatColor.RED : ChatColor.DARK_RED;
                    }
                } else if (!p.hasPermission("craftbook.ic.safe." + ic.toLowerCase())) {
                    colour = col ? ChatColor.RED : ChatColor.DARK_RED;
                }
                strings.add(colour + tic.getTitle() + " (" + ric.getId() + ")" + ": " + (tic instanceof SelfTriggeredIC ? "ST " : "T ") + (ric.getFactory() instanceof RestrictedIC ? ChatColor.DARK_RED + "R " : ""));
            }
            catch (Throwable e) {
                Bukkit.getLogger().severe("An error occured generating the docs for IC: " + ic + ". Please report" + " it to Me4502");
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    public void reloadICConfiguration() {
        this.icConfig = new ICConfiguration((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "ic-config.yml")), this.getDataFolder());
        try {
            this.icConfig.cfg.save(new File(this.getDataFolder(), "ic-config.yml"));
        }
        catch (IOException ex) {
            this.getLogger().log(Level.SEVERE, "Could not save IC Config", ex);
        }
    }

    public void reloadConfiguration() {
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                CircuitsPlugin.this.unregisterAllMechanics();
                HandlerList.unregisterAll((Plugin)CircuitsPlugin.getInst());
                CircuitsPlugin.this.reloadConfig();
                CircuitsPlugin.this.config = new CircuitsConfiguration(CircuitsPlugin.this.getConfig(), CircuitsPlugin.this.getDataFolder());
                CircuitsPlugin.this.saveConfig();
                CircuitsPlugin.this.registerMechanics();
                CircuitsPlugin.this.registerEvents();
            }
        });
    }
}

