/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class FlexibleSetBlock
extends AbstractIC {
    int x;
    int y;
    int z;
    Block body;
    boolean hold;
    int block;
    byte data;

    public FlexibleSetBlock(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        int dist;
        String line3 = this.getSign().getLine(2).toUpperCase();
        String line4 = this.getSign().getLine(3);
        String[] params = RegexUtil.COLON_PATTERN.split(line3);
        if (params.length < 2) {
            return;
        }
        if (params[0].length() < 2) {
            return;
        }
        String axis = params[0].substring(0, 1);
        if (!(axis.equals("X") || axis.equals("Y") || axis.equals("Z"))) {
            return;
        }
        String op = params[0].substring(1, 2);
        int distStart = 2;
        if (!op.equals("+") && !op.equals("-")) {
            op = "+";
            distStart = 1;
        }
        String sdist = params[0].substring(distStart);
        try {
            dist = Integer.parseInt(sdist);
        }
        catch (Exception e) {
            return;
        }
        if (op.equals("-")) {
            dist = -dist;
        }
        try {
            this.block = Integer.parseInt(params[1]);
        }
        catch (Exception e) {
            return;
        }
        if (params.length > 2) {
            try {
                this.data = Byte.parseByte(params[2]);
            }
            catch (Exception e) {
                this.data = 0;
            }
        } else {
            this.data = 0;
        }
        this.hold = line4.toUpperCase().contains("H");
        this.body = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        this.x = this.body.getX();
        this.y = this.body.getY();
        this.z = this.body.getZ();
        if (axis.equals("X")) {
            this.x += dist;
        } else if (axis.equals("Y")) {
            this.y += dist;
        } else {
            this.z += dist;
        }
    }

    public String getTitle() {
        return "Flexible Set";
    }

    public String getSignTitle() {
        return "FLEX SET";
    }

    public void trigger(ChipState chip) {
        chip.setOutput(0, chip.getInput(0));
        boolean inp = chip.getInput(0);
        if (this.body == null) {
            return;
        }
        if (inp) {
            this.body.getWorld().getBlockAt(this.x, this.y, this.z).setTypeIdAndData(this.block, this.data, true);
        } else if (this.hold) {
            this.body.getWorld().getBlockAt(this.x, this.y, this.z).setTypeId(0);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new FlexibleSetBlock(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            String line3 = sign.getLine(2).toUpperCase();
            String[] params = RegexUtil.COLON_PATTERN.split(line3);
            if (params.length < 2) {
                throw new ICVerificationException("Not enough parameters on second line!");
            }
            if (params[0].length() < 2) {
                throw new ICVerificationException("Invalid first parameter!");
            }
            String axis = params[0].substring(0, 1);
            if (!(axis.equals("X") || axis.equals("Y") || axis.equals("Z"))) {
                throw new ICVerificationException("Invalid axis!");
            }
            String op = params[0].substring(1, 2);
            int distStart = 2;
            if (!op.equals("+") && !op.equals("-")) {
                op = "+";
                distStart = 1;
            }
            String sdist = params[0].substring(distStart);
            try {
                Integer.parseInt(sdist);
            }
            catch (Exception e) {
                throw new ICVerificationException("Invalid distance!");
            }
            try {
                Integer.parseInt(params[1]);
            }
            catch (Exception e) {
                throw new ICVerificationException("Invalid block ID!");
            }
            if (params.length > 2) {
                try {
                    Byte.parseByte(params[2]);
                }
                catch (Exception e) {
                    throw new ICVerificationException("Invalid block data!");
                }
            }
        }
    }
}

