/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class LiquidFlood
extends AbstractIC {
    int radius;
    String liquid;
    Location centre;

    public LiquidFlood(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Liquid Flooder";
    }

    public String getSignTitle() {
        return "LIQUID FLOOD";
    }

    public void load() {
        this.centre = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        try {
            if (this.getSign().getLine(2).contains("=")) {
                String[] splitEquals = RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2), 2);
                this.radius = Integer.parseInt(splitEquals[0]);
                String[] splitCoords = RegexUtil.COLON_PATTERN.split(splitEquals[1]);
                int x = Integer.parseInt(splitCoords[0]);
                int y = Integer.parseInt(splitCoords[1]);
                int z = Integer.parseInt(splitCoords[2]);
                if (x > 16) {
                    x = 16;
                }
                if (x < -16) {
                    x = -16;
                }
                if (y > 16) {
                    y = 16;
                }
                if (y < -16) {
                    y = -16;
                }
                if (z > 16) {
                    z = 16;
                }
                if (z < -16) {
                    z = -16;
                }
                this.centre.add((double)x, (double)y, (double)z);
            } else {
                this.radius = Integer.parseInt(this.getLine(2));
            }
        }
        catch (Exception ignored) {
            this.radius = 10;
        }
        this.liquid = this.getSign().getLine(2).equalsIgnoreCase("lava") ? "lava" : "water";
    }

    public void doStuff(ChipState chip) {
        block7: {
            block6: {
                if (!chip.getInput(0)) break block6;
                for (int x = -this.radius + 1; x < this.radius; ++x) {
                    for (int y = -this.radius + 1; y < this.radius; ++y) {
                        for (int z = -this.radius + 1; z < this.radius; ++z) {
                            int rx = this.centre.getBlockX() - x;
                            int ry = this.centre.getBlockY() - y;
                            int rz = this.centre.getBlockZ() - z;
                            Block b = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                            if (b.getTypeId() != 0 && b.getTypeId() != (this.liquid.equalsIgnoreCase("water") ? 8 : 10)) continue;
                            b.setTypeId(this.liquid.equalsIgnoreCase("water") ? 9 : 11);
                        }
                    }
                }
                break block7;
            }
            if (chip.getInput(0)) break block7;
            for (int x = -this.radius + 1; x < this.radius; ++x) {
                for (int y = -this.radius + 1; y < this.radius; ++y) {
                    for (int z = -this.radius + 1; z < this.radius; ++z) {
                        int rx = this.centre.getBlockX() - x;
                        int ry = this.centre.getBlockY() - y;
                        int rz = this.centre.getBlockZ() - z;
                        Block b = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getBlockAt(rx, ry, rz);
                        if (b.getTypeId() != (this.liquid.equalsIgnoreCase("water") ? 8 : 10) && b.getTypeId() != (this.liquid.equalsIgnoreCase("water") ? 9 : 11)) continue;
                        b.setTypeId(0);
                    }
                }
            }
        }
    }

    public void trigger(ChipState chip) {
        this.doStuff(chip);
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new LiquidFlood(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Floods an area with a liquid.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"water/lava", "radius=x:y:z offset"};
            return lines;
        }
    }
}

