/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.inventory.ItemStack;

public class Pump
extends AbstractIC {
    public Pump(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Pump";
    }

    public String getSignTitle() {
        return "PUMP";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.scan());
        }
    }

    public boolean scan() {
        Block pump = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
        if (pump.getRelative(0, 1, 0).getTypeId() != 54) {
            return false;
        }
        Chest c = (Chest)pump.getRelative(0, 1, 0).getState();
        for (int y = 0; y > -10; --y) {
            Block liquid = pump.getRelative(0, y, 0);
            if (!this.check(c, liquid, 0)) continue;
            return true;
        }
        return false;
    }

    public boolean searchNear(Chest c, Block block, int depth) {
        return depth <= 5 && (this.check(c, block.getRelative(0, 0, 1), depth) || this.check(c, block.getRelative(0, 0, -1), depth) || this.check(c, block.getRelative(1, 0, 0), depth) || this.check(c, block.getRelative(-1, 0, 0), depth));
    }

    public boolean check(Chest c, Block liquid, int depth) {
        if (!liquid.isLiquid()) {
            return false;
        }
        if (liquid.getData() == 0) {
            if (this.addToChest(c, liquid)) {
                liquid.setTypeId(0);
                return true;
            }
        } else if (this.searchNear(c, liquid, depth + 1)) {
            return true;
        }
        return false;
    }

    public boolean addToChest(Chest c, Block liquid) {
        if (((Factory)this.getFactory()).buckets) {
            if (c.getInventory().contains(325)) {
                c.getInventory().remove(325);
                if (c.getInventory().addItem(new ItemStack[]{new ItemStack(this.parse(liquid.getTypeId()) == 10 ? 327 : 326, 1)}).size() < 1) {
                    return true;
                }
                c.getInventory().addItem(new ItemStack[]{new ItemStack(325)});
                return false;
            }
            return false;
        }
        return c.getInventory().addItem(new ItemStack[]{new ItemStack(this.parse(liquid.getTypeId()))}).size() < 1;
    }

    public int parse(int mat) {
        if (mat == 9 || mat == 8) {
            return 8;
        }
        if (mat == 11 || mat == 10) {
            return 10;
        }
        return 0;
    }

    public static class Factory
    extends AbstractICFactory {
        public boolean buckets;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Pump(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Pumps liquids into above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{null, null};
            return lines;
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.buckets = section.getBoolean("requires-buckets", false);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

