/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.blocks;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.gates.world.blocks.SetBlock;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class SetBlockBelowChest
extends SetBlock {
    public SetBlockBelowChest(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Set Block Below (Chest)";
    }

    public String getSignTitle() {
        return "SET BLOCK BELOW";
    }

    protected void doSet(Block body, int block, byte meta, boolean force) {
        int x = body.getX();
        int y = body.getY();
        int z = body.getZ();
        if ((force || body.getWorld().getBlockAt(x, y - 1, z).getTypeId() == 0) && this.takeFromChest(body.getRelative(0, 1, 0), block, meta)) {
            body.getWorld().getBlockAt(x, y - 1, z).setTypeId(block);
            if (meta != -1) {
                body.getWorld().getBlockAt(x, y - 1, z).setData(meta);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new SetBlockBelowChest(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Sets below block from above chest.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"id:data", "forced or not"};
            return lines;
        }
    }
}

