/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.entity;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.Tuple2;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeleportTransmitter
extends AbstractIC {
    protected static final HistoryHashMap<String, Tuple2<Long, String>> memory = new HistoryHashMap(50);
    protected String band;
    int radius;
    Location offset;

    public TeleportTransmitter(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    @Override
    public String getTitle() {
        return "Teleport Transmitter";
    }

    @Override
    public String getSignTitle() {
        return "TELEPORT OUT";
    }

    @Override
    public void load() {
        this.band = this.getLine(2);
        this.offset = BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation();
        try {
            String[] splitEquals = RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2), 2);
            this.radius = Integer.parseInt(splitEquals[0]);
            if (this.getSign().getLine(2).contains("=")) {
                String[] splitCoords = RegexUtil.COLON_PATTERN.split(splitEquals[1]);
                int x = Integer.parseInt(splitCoords[0]);
                int y = Integer.parseInt(splitCoords[1]);
                int z = Integer.parseInt(splitCoords[2]);
                this.offset.add((double)x, (double)y, (double)z);
            }
        }
        catch (Exception e) {
            this.radius = 3;
        }
    }

    @Override
    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Player closest = null;
            for (Player e : this.offset.getWorld().getPlayers()) {
                if (e == null || !e.isValid() || !LocationUtil.isWithinRadius((Location)this.offset, (Location)e.getLocation(), (int)this.radius)) continue;
                if (closest == null) {
                    closest = e;
                    continue;
                }
                if (!(closest.getLocation().distanceSquared(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation()) > e.getLocation().distanceSquared(BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation()))) continue;
                closest = e;
            }
            if (closest != null && !TeleportTransmitter.setValue(this.band, (Tuple2<Long, String>)new Tuple2((Object)System.currentTimeMillis(), (Object)closest.getName()))) {
                closest.sendMessage(ChatColor.RED + "This Teleporter Frequency is currently busy! Try again soon!");
            }
            return;
        }
    }

    public static Tuple2<Long, String> getValue(String band) {
        long time;
        int seconds;
        if (memory.containsKey((Object)band) && (seconds = (int)((time = System.currentTimeMillis() - (Long)((Tuple2)TeleportTransmitter.memory.get((Object)band)).a) / 1000L) % 60) > 5) {
            memory.remove((Object)band);
            return null;
        }
        Tuple2 val = (Tuple2)memory.get((Object)band);
        memory.remove((Object)band);
        return val;
    }

    public static boolean setValue(String band, Tuple2<Long, String> val) {
        if (memory.containsKey((Object)band)) {
            long time = System.currentTimeMillis() - (Long)((Tuple2)TeleportTransmitter.memory.get((Object)band)).a;
            int seconds = (int)(time / 1000L) % 60;
            if (seconds > 5) {
                memory.remove((Object)band);
            } else {
                return false;
            }
        }
        memory.put((Object)band, val);
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new TeleportTransmitter(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Transmitter for the teleportation network.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"frequency name", "radius=x:y:z offset"};
            return lines;
        }
    }
}

