/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.items;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class ItemDispenser
extends AbstractIC {
    ItemStack item;

    public ItemDispenser(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        int amount = 1;
        try {
            amount = Math.min(64, Math.max(1, Integer.parseInt(this.getSign().getLine(3))));
        }
        catch (Exception ignored) {
            amount = 1;
        }
        if (amount < 1) {
            amount = 1;
        }
        this.item = ICUtil.getItem(this.getLine(2));
        this.item.setAmount(amount);
    }

    public String getTitle() {
        return "Item Dispenser";
    }

    public String getSignTitle() {
        return "ITEM DISPENSER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0) && this.item.getTypeId() != 36) {
            Location loc = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock()).getRelative(0, 1, 0).getLocation().add(0.5, 0.5, 0.5);
            int maxY = 10;
            for (int y = 1; y <= maxY; ++y) {
                if (!BlockType.canPassThrough((int)loc.getBlock().getRelative(0, y, 0).getTypeId())) continue;
                ItemStack stack = this.item.clone();
                BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().dropItemNaturally(loc.getBlock().getRelative(0, y, 0).getLocation(), stack);
                return;
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ItemDispenser(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Spawns in items.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"id:data", "amount"};
            return lines;
        }
    }
}

