/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class FlameThrower
extends AbstractIC {
    int distance = 5;

    public FlameThrower(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        try {
            this.distance = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Flame Thrower";
    }

    public String getSignTitle() {
        return "FLAME THROWER";
    }

    public void trigger(ChipState chip) {
        this.sendFlames(chip.getInput(0));
    }

    public void sendFlames(boolean make) {
        Block block = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock();
        BlockFace direction = SignUtil.getBack((Block)block);
        Block fire = block.getRelative(direction, 2);
        for (int i = 0; i < this.distance; ++i) {
            if (make) {
                if (fire.getTypeId() == 0 || fire.getTypeId() == 31) {
                    fire.setTypeId(51);
                }
            } else if (fire.getTypeId() == 51) {
                fire.setTypeId(0);
            }
            fire = fire.getRelative(direction);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new FlameThrower(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Makes a line of fire.";
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            try {
                int distance = Integer.parseInt(sign.getLine(2));
                if (distance > 20) {
                    throw new ICVerificationException("Distance too great!");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"distance", null};
            return lines;
        }
    }
}

