/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.gates.world.sensors.PowerSensor;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.jinglenote.JingleNoteManager;
import com.sk89q.craftbook.jinglenote.MidiJingleSequencer;
import com.sk89q.craftbook.util.GeneralUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.RegexUtil;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class Melody
extends AbstractIC {
    MidiJingleSequencer sequencer;
    JingleNoteManager jNote = new JingleNoteManager();
    int radius;
    File file;
    String midiName;
    boolean forceStart;

    public Melody(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Melody Player";
    }

    public String getSignTitle() {
        return "MELODY";
    }

    public void unload() {
        try {
            this.sequencer.stop();
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.jNote.stop(player);
            }
            this.jNote.stopAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        File[] trialPaths;
        try {
            String[] split = RegexUtil.COLON_PATTERN.split(this.getSign().getLine(3));
            try {
                this.radius = Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                this.radius = -1;
            }
            this.forceStart = split[1].equalsIgnoreCase("START");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.midiName = this.getSign().getLine(2);
        for (File f : trialPaths = new File[]{new File(CircuitsPlugin.getInst().midiFolder, this.midiName), new File(CircuitsPlugin.getInst().midiFolder, this.midiName + ".mid"), new File(CircuitsPlugin.getInst().midiFolder, this.midiName + ".midi"), new File("midi", this.midiName), new File("midi", this.midiName + ".mid"), new File("midi", this.midiName + ".midi")}) {
            if (!f.exists()) continue;
            this.file = f;
            break;
        }
    }

    public void trigger(ChipState chip) {
        if (this.file == null || !this.file.exists()) {
            this.getServer().getLogger().log(Level.SEVERE, "Midi file not found!");
            return;
        }
        try {
            if (this.sequencer != null && !this.sequencer.isSongPlaying() && this.forceStart) {
                return;
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            if (chip.getInput(0)) {
                if (this.sequencer != null || this.jNote != null) {
                    for (Player player : this.getServer().getOnlinePlayers()) {
                        this.jNote.stop(player);
                    }
                    this.jNote.stopAll();
                }
                this.sequencer = new MidiJingleSequencer(this.file);
                for (Player player : this.getServer().getOnlinePlayers()) {
                    if (player == null || this.radius > 0 && !LocationUtil.isWithinRadius((Location)BukkitUtil.toSign((ChangedSign)this.getSign()).getLocation(), (Location)player.getLocation(), (int)this.radius)) continue;
                    this.jNote.play(player, this.sequencer);
                    player.sendMessage(ChatColor.YELLOW + "Playing " + this.midiName + "...");
                }
            } else if (!chip.getInput(0) && this.sequencer != null) {
                this.sequencer.stop();
                for (Player player : this.getServer().getOnlinePlayers()) {
                    this.jNote.stop(player);
                }
                this.jNote.stopAll();
            }
        }
        catch (Throwable e) {
            this.getServer().getLogger().log(Level.SEVERE, "[CraftBookCircuits]: Midi Failed To Play!");
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            try {
                if (sign.getLine(0).equalsIgnoreCase("POWER SENSOR")) {
                    sign.setLine(1, "[MC1266]");
                    sign.update(false);
                    return new PowerSensor(this.getServer(), sign, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new Melody(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Plays a MIDI.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"MIDI name", "Radius"};
            return lines;
        }
    }
}

