/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public class MessageSender
extends AbstractIC {
    public MessageSender(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Message Sender";
    }

    public String getSignTitle() {
        return "MESSAGE SENDER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendMessage());
        }
    }

    public void load() {
    }

    private boolean sendMessage() {
        boolean sent = false;
        String name = this.getLine(2);
        String message = this.getLine(3);
        Player player = this.getServer().getPlayer(name);
        if (player != null) {
            player.sendMessage(message.replace("&", "\u00a7"));
            sent = true;
        } else if (name.equalsIgnoreCase("BROADCAST")) {
            this.getServer().broadcastMessage(message);
        }
        return sent;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new MessageSender(this.getServer(), sign, this);
        }

        public void checkPlayer(ChangedSign sign, LocalPlayer player) throws ICVerificationException {
            if (!sign.getLine(2).equalsIgnoreCase(player.getName()) && !player.hasPermission("craftbook.ic.restricted.mc1510")) {
                throw new ICVerificationException("You don't have permission to use other players!");
            }
        }

        public String getDescription() {
            return "Sends a pre-written message on high.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"name of player, or BROADCAST for whole server", "Message to send."};
            return lines;
        }
    }
}

