/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.gates.world.blocks.SetDoor;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Effect;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class ParticleEffect
extends AbstractIC {
    int effectID;
    int effectData;
    int times;
    Vector offset;

    public ParticleEffect(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Particle Effect";
    }

    public String getSignTitle() {
        return "PARTICLE EFFECT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.doEffect();
        }
    }

    public void load() {
        String[] eff = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[0], 2);
        try {
            this.effectID = Integer.parseInt(eff[0]);
        }
        catch (Exception e) {
            this.effectID = Effect.valueOf((String)eff[0]).getId();
        }
        if (Effect.getById((int)this.effectID) == null) {
            return;
        }
        try {
            this.effectData = Integer.parseInt(eff[1]);
        }
        catch (Exception e) {
            this.effectData = 0;
        }
        try {
            this.times = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            this.times = 1;
        }
        try {
            String[] off = RegexUtil.COLON_PATTERN.split(RegexUtil.EQUALS_PATTERN.split(this.getSign().getLine(2))[1], 2);
            this.offset = new Vector(Double.parseDouble(off[0]), Double.parseDouble(off[1]), Double.parseDouble(off[2]));
        }
        catch (Exception e) {
            this.offset = new Vector(0, 1, 0);
        }
    }

    public void doEffect() {
        try {
            if (this.effectID == 0) {
                return;
            }
            if (this.effectID == 2001 && BlockType.fromID((int)this.effectData) == null) {
                return;
            }
            Block b = SignUtil.getBackBlock((Block)BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock());
            for (int i = 0; i < this.times; ++i) {
                b.getWorld().playEffect(b.getLocation().add(this.offset), Effect.getById((int)this.effectID), this.effectData, 50);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            try {
                if (sign.getLine(0).equalsIgnoreCase("SET P-DOOR")) {
                    sign.setLine(1, "[MC1212]");
                    sign.update(false);
                    return new SetDoor(this.getServer(), sign, this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ParticleEffect(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Creates particle effects.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"effectID:effectData=xOff:yOff:zOff", "amount of particles"};
            return lines;
        }
    }
}

