/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.miscellaneous;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.gates.world.miscellaneous.WirelessTransmitter;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;

public class WirelessReceiver
extends AbstractIC {
    protected String band;

    public WirelessReceiver(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public void load() {
        this.band = this.getSign().getLine(2);
        if (!this.getLine(3).trim().isEmpty()) {
            this.band = this.band + this.getSign().getLine(3);
        }
    }

    public String getTitle() {
        return "Wireless Receiver";
    }

    public String getSignTitle() {
        return "RECEIVER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Boolean val = WirelessTransmitter.getValue(this.band);
            if (val == null) {
                chip.setOutput(0, false);
                return;
            }
            chip.setOutput(0, val);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public boolean requirename;

        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new WirelessReceiver(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Recieves signal from wireless transmitter.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"wireless band", "user"};
            return lines;
        }

        public void checkPlayer(ChangedSign sign, LocalPlayer player) throws ICVerificationException {
            if (this.requirename) {
                sign.setLine(3, player.getName());
            } else if (!sign.getLine(3).isEmpty()) {
                sign.setLine(3, player.getName());
            }
            sign.update(false);
        }

        public void addConfiguration(BaseConfiguration.BaseConfigurationSection section) {
            this.requirename = section.getBoolean("per-player", false);
        }

        public boolean needsConfiguration() {
            return true;
        }
    }
}

