/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import org.bukkit.Server;

public class DaySensor
extends AbstractIC {
    long day;
    long night;

    public DaySensor(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Day Sensor";
    }

    public String getSignTitle() {
        return "DAY SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDay());
        }
    }

    public void load() {
        try {
            this.night = Long.parseLong(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            this.night = 13000L;
        }
        try {
            this.day = Long.parseLong(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            this.day = 0L;
        }
    }

    protected boolean isDay() {
        long time = BukkitUtil.toSign((ChangedSign)this.getSign()).getWorld().getTime();
        if (time < 0L) {
            time += 24000L;
        }
        if (this.day <= this.night) {
            return time >= this.day && time <= this.night;
        }
        if (this.day >= this.night) {
            return time <= this.day || time >= this.night;
        }
        return time < this.night;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new DaySensor(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Outputs high if it is day.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"custom day start", "custom day end"};
            return lines;
        }
    }
}

