/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.sensors;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Block;

public class PowerSensor
extends AbstractIC {
    private Block center;

    public PowerSensor(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    public String getTitle() {
        return "Power Sensor";
    }

    public String getSignTitle() {
        return "POWER SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isPowered());
        }
    }

    protected boolean isPowered() {
        return this.center.isBlockPowered() || this.center.isBlockIndirectlyPowered();
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new PowerSensor(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }

        public String getDescription() {
            return "Detects if offset block is powered.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"x:y:z offset", null};
            return lines;
        }
    }
}

