/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world.weather;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import org.bukkit.Server;

public class ServerTimeModulus
extends AbstractIC {
    public ServerTimeModulus(Server server, ChangedSign sign, ICFactory factory) {
        super(server, sign, factory);
    }

    public String getTitle() {
        return "Server Time Modulus";
    }

    public String getSignTitle() {
        return "SERVER TIME MOD";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isServerTimeOdd());
        }
    }

    private boolean isServerTimeOdd() {
        long time = BukkitUtil.toSign((ChangedSign)this.getSign()).getBlock().getWorld().getTime() % 2L;
        if (time < 0L) {
            time += 2L;
        }
        return time == 1L;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new ServerTimeModulus(this.getServer(), sign, this);
        }

        public String getDescription() {
            return "Outputs high if time is odd.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{null, null};
            return lines;
        }
    }
}

