/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.RegisteredICFactory;
import com.sk89q.craftbook.util.RegexUtil;
import com.sk89q.worldedit.BlockWorldVector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class ICManager {
    public final Map<String, RegisteredICFactory> registered = new HashMap<String, RegisteredICFactory>();
    public final Map<String, String> longRegistered = new HashMap<String, String>();
    private static final Map<BlockWorldVector, IC> cachedICs = new HashMap<BlockWorldVector, IC>();
    private static final Set<String> customPrefix = new HashSet<String>();

    public void register(String id, ICFactory factory, ICFamily ... families) {
        this.register(id, null, factory, families);
    }

    public boolean register(String id, String longId, ICFactory factory, ICFamily ... families) {
        if (families.length < 1) {
            return false;
        }
        String id2 = "[" + id + "]";
        if (this.registered.containsKey(id.toLowerCase())) {
            return false;
        }
        Matcher matcher = RegexUtil.IC_PATTERN.matcher(id2);
        if (!matcher.matches()) {
            return false;
        }
        String prefix = matcher.group(2).toLowerCase();
        customPrefix.add(prefix);
        RegisteredICFactory registration = new RegisteredICFactory(id, longId, factory, families);
        this.registered.put(id.toLowerCase(), registration);
        if (longId != null) {
            String toRegister = longId.toLowerCase();
            if (toRegister.length() > 15) {
                toRegister = toRegister.substring(0, 15);
            }
            this.longRegistered.put(toRegister, id);
        }
        return true;
    }

    public RegisteredICFactory get(String id) {
        return this.registered.get(id.toLowerCase());
    }

    public static boolean isCachedIC(BlockWorldVector pt) {
        return CircuitsPlugin.getInst().getLocalConfiguration().icSettings.cache && cachedICs.containsKey(pt);
    }

    public static IC getCachedIC(BlockWorldVector pt) {
        return cachedICs.get(pt);
    }

    public static void addCachedIC(BlockWorldVector pt, IC ic) {
        if (!CircuitsPlugin.getInst().getLocalConfiguration().icSettings.cache) {
            return;
        }
        cachedICs.put(pt, ic);
    }

    public static IC removeCachedIC(BlockWorldVector pt) {
        if (cachedICs.containsKey(pt)) {
            return cachedICs.remove(pt);
        }
        return null;
    }

    public static void unloadIC(BlockWorldVector pt) {
        ICManager.removeCachedIC(pt);
    }

    public boolean hasCustomPrefix(String prefix) {
        return customPrefix.contains(prefix.toLowerCase());
    }
}

