/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic.families;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.bukkit.BukkitUtil;
import com.sk89q.craftbook.ic.AbstractChipState;
import com.sk89q.craftbook.ic.AbstractICFamily;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class FamilyAISO
extends AbstractICFamily {
    public ChipState detect(BlockWorldVector source, ChangedSign sign) {
        return new ChipStateAISO(source, sign);
    }

    public ChipState detectSelfTriggered(BlockWorldVector source, ChangedSign sign) {
        return new ChipStateAISO(source, sign, true);
    }

    public String getSuffix() {
        return "A";
    }

    public static class ChipStateAISO
    extends AbstractChipState {
        public ChipStateAISO(BlockWorldVector source, ChangedSign sign) {
            super(source, sign, false);
        }

        public ChipStateAISO(BlockWorldVector source, ChangedSign sign, boolean selfTriggered) {
            super(source, sign, selfTriggered);
        }

        protected Block getBlock(int pin) {
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock((Block)BukkitUtil.toSign((ChangedSign)this.sign).getBlock());
                }
                case 1: {
                    return SignUtil.getLeftBlock((Block)BukkitUtil.toSign((ChangedSign)this.sign).getBlock());
                }
                case 2: {
                    return SignUtil.getRightBlock((Block)BukkitUtil.toSign((ChangedSign)this.sign).getBlock());
                }
                case 3: {
                    BlockFace face = SignUtil.getBack((Block)BukkitUtil.toSign((ChangedSign)this.sign).getBlock());
                    return BukkitUtil.toSign((ChangedSign)this.sign).getBlock().getRelative(face).getRelative(face);
                }
            }
            return null;
        }

        public boolean getInput(int inputIndex) {
            for (int i = 0; i < this.getInputCount(); ++i) {
                if (!this.isValid(i) || !this.get(i)) continue;
                return true;
            }
            return false;
        }

        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 3);
        }

        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 3, value);
        }

        public int getInputCount() {
            return 3;
        }

        public int getOutputCount() {
            return 1;
        }
    }
}

