/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.jinglenote;

import com.sk89q.craftbook.jinglenote.JingleNotePlayer;
import com.sk89q.craftbook.jinglenote.JingleSequencer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class JingleNoteManager {
    protected final Map<String, JingleNotePlayer> instances = new HashMap<String, JingleNotePlayer>();

    public void play(Player player, JingleSequencer sequencer) {
        String name = player.getName();
        if (this.instances.containsKey(name)) {
            JingleNotePlayer existing = this.instances.get(name);
            existing.stop();
            this.instances.remove(name);
        }
        JingleNotePlayer notePlayer = new JingleNotePlayer(name, sequencer);
        Thread thread = new Thread(notePlayer);
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.setName("JingleNotePlayer for " + player.getName());
        thread.start();
        this.instances.put(name, notePlayer);
    }

    public boolean stop(Player player) {
        String name = player.getName();
        if (this.instances.containsKey(name)) {
            JingleNotePlayer existing = this.instances.get(name);
            existing.stop();
            this.instances.remove(name);
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop();
        }
        this.instances.clear();
    }
}

