/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.jinglenote;

import com.sk89q.craftbook.jinglenote.JingleNotePlayer;
import com.sk89q.craftbook.jinglenote.JingleSequencer;
import com.sk89q.craftbook.util.GeneralUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import org.bukkit.Bukkit;
import org.bukkit.Sound;

public class MidiJingleSequencer
implements JingleSequencer {
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 3, 1, 1, 1, 5, 1, 1, 1, 1, 1, 2, 4, 3};
    private static int[] percussion = new int[]{1, 1, 1, 2, 3, 2, 1, 3, 1, 3, 1, 3, 1, 1, 3, 1, 3, 3, 3, 3, 3, 0, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 4, 4, 3, 3, 3, 3, 3, 1, 1, 3, 3, 2, 4, 4, 3, 1, 1};
    protected final File midiFile;
    private Sequencer sequencer = null;

    public MidiJingleSequencer(File midiFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this.midiFile = midiFile;
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.open();
            Sequence seq = MidiSystem.getSequence(midiFile);
            this.sequencer.setSequence(seq);
        }
        catch (MidiUnavailableException e) {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
        catch (InvalidMidiDataException e) {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
        catch (IOException e) {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final JingleNotePlayer notePlayer) throws InterruptedException {
        final HashMap patches = new HashMap();
        try {
            if (!this.sequencer.isOpen()) {
                this.sequencer.open();
            }
            this.sequencer.getTransmitter().setReceiver(new Receiver(){

                public void send(MidiMessage message, long timeStamp) {
                    if ((message.getStatus() & 0xF0) == 192) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int patch = msg.getData1();
                        patches.put(chan, patch);
                    } else if ((message.getStatus() & 0xF0) == 144) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int n = msg.getData1();
                        if (chan != 9) {
                            notePlayer.play(new JingleSequencer.Note(MidiJingleSequencer.this.toMCSound(MidiJingleSequencer.toMCInstrument((Integer)patches.get(chan))), MidiJingleSequencer.toMCNote(n), msg.getData2()));
                        }
                    }
                }

                public void close() {
                }
            });
            this.sequencer.start();
            while (this.sequencer.isRunning()) {
                Thread.sleep(1000L);
            }
            if (this.sequencer.isRunning()) {
                this.sequencer.stop();
            }
        }
        catch (MidiUnavailableException e) {
            Bukkit.getLogger().severe(GeneralUtil.getStackTrace((Throwable)e));
        }
        finally {
            if (this.sequencer.isOpen()) {
                this.sequencer.close();
            }
        }
    }

    public void stop() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.close();
        }
    }

    private static byte toMCNote(int n) {
        if (n < 54) {
            return (byte)((n - 6) % 12);
        }
        if (n > 78) {
            return (byte)((n - 6) % 12 + 12);
        }
        return (byte)(n - 54);
    }

    private static byte toMCInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return (byte)instruments[patch];
    }

    public Sound toMCSound(byte instrument) {
        switch (instrument) {
            case 0: {
                return Sound.NOTE_PIANO;
            }
            case 1: {
                return Sound.NOTE_BASS_GUITAR;
            }
            case 2: {
                return Sound.NOTE_SNARE_DRUM;
            }
            case 3: {
                return Sound.NOTE_STICKS;
            }
            case 4: {
                return Sound.NOTE_BASS_DRUM;
            }
            case 5: {
                return Sound.NOTE_PLING;
            }
            case 6: {
                return Sound.NOTE_BASS;
            }
        }
        return Sound.NOTE_PIANO;
    }

    private static int toMCPercussion(int note) {
        int i = note - 35;
        if (i < 0 || i >= percussion.length) {
            return 1;
        }
        return percussion[i];
    }

    public boolean isSongPlaying() {
        return this.sequencer.isRunning();
    }
}

