/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfiguration {
    public final FileConfiguration cfg;
    public final CommonSettings commonSettings;

    public BaseConfiguration(FileConfiguration cfg, File dataFolder) {
        this.cfg = cfg;
        this.commonSettings = new CommonSettings();
    }

    public int getInt(String name, int def) {
        int it = this.cfg.getInt(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public double getDouble(String name, double def) {
        double it = this.cfg.getDouble(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public boolean getBoolean(String name, boolean def) {
        boolean it = this.cfg.getBoolean(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public String getString(String name, String def) {
        String it = this.cfg.getString(name, def);
        this.cfg.set(name, (Object)it);
        return it;
    }

    public Set<Integer> getIntegerSet(String name, List<Integer> def) {
        List<Integer> tids = this.cfg.getIntegerList(name);
        if (tids == null || tids.isEmpty() || tids.size() < 1) {
            tids = def;
        }
        HashSet<Integer> allowedBlocks = new HashSet<Integer>();
        for (Integer tid : tids) {
            allowedBlocks.add(tid);
        }
        this.cfg.set(name, tids);
        return allowedBlocks;
    }

    public Set<Material> getMaterialSet(String name, List<Integer> def) {
        List<Integer> tids = this.cfg.getIntegerList(name);
        if (tids == null || tids.isEmpty() || tids.size() < 1) {
            tids = def;
        }
        HashSet<Material> allowedBlocks = new HashSet<Material>();
        for (Integer tid : tids) {
            allowedBlocks.add(Material.getMaterial((int)tid));
        }
        this.cfg.set(name, tids);
        return Collections.unmodifiableSet(allowedBlocks);
    }

    public class CommonSettings {
        public final String language;
        public final boolean opPerms;
        public final boolean useBlockDistance;

        private CommonSettings() {
            this.language = BaseConfiguration.this.getString("language", "en_US");
            this.opPerms = BaseConfiguration.this.getBoolean("op-perms", true);
            this.useBlockDistance = BaseConfiguration.this.getBoolean("use-block-radius", false);
        }
    }
}

