/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.logging.Level;
import org.bukkit.ChatColor;

public class LanguageManager {
    final BaseBukkitPlugin plugin;
    final HashMap<String, String> languageData = new HashMap();

    public LanguageManager(BaseBukkitPlugin plugin) {
        this.plugin = plugin;
        this.checkForLanguages();
    }

    public void checkForLanguages() {
        String language = this.plugin.getLocalConfiguration().commonSettings.language;
        File f = new File(this.plugin.getDataFolder(), language + ".txt");
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.split(":").length != 2) continue;
                this.languageData.put(line.split(":")[0], line.split(":")[1]);
            }
            br.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "[CraftBook] could not find file: " + this.plugin.getDataFolder().getName() + File.pathSeparator + language + ".txt");
        }
    }

    public String getString(String s) {
        if (this.languageData.get(ChatColor.stripColor((String)s)) == null) {
            return s;
        }
        return this.languageData.get(ChatColor.stripColor((String)s));
    }
}

