/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.BlockWorldVector2D;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.event.block.BlockEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WatchBlockManager {
    private final Map<BlockWorldVector, Set<PersistentMechanic>> watchBlocks = new HashMap<BlockWorldVector, Set<PersistentMechanic>>();

    public void register(PersistentMechanic m) {
        for (BlockWorldVector p : m.getWatchedPositions()) {
            Set<PersistentMechanic> set = this.watchBlocks.get(p);
            if (set == null) {
                set = new HashSet<PersistentMechanic>(4);
                this.watchBlocks.put(p, set);
            }
            set.add(m);
        }
    }

    public void update(PersistentMechanic m, List<BlockWorldVector> oldWatchBlocks) {
        for (BlockWorldVector p : oldWatchBlocks) {
            this.watchBlocks.get(p).remove(m);
        }
        this.register(m);
    }

    public void deregister(PersistentMechanic m) {
        for (BlockWorldVector p : m.getWatchedPositions()) {
            if (p == null || this.watchBlocks.get(p) == null) continue;
            this.watchBlocks.get(p).remove(m);
        }
    }

    public void notify(BlockEvent event) {
        Set<PersistentMechanic> pms = this.watchBlocks.get(BukkitUtil.toWorldVector((Block)event.getBlock()));
        if (pms == null) {
            return;
        }
        for (PersistentMechanic m : pms) {
            m.onWatchBlockNotification(event);
        }
    }

    public Set<PersistentMechanic> getByChunk(BlockWorldVector2D chunk) {
        HashSet<PersistentMechanic> folks = new HashSet<PersistentMechanic>();
        int chunkX = chunk.getBlockX();
        int chunkZ = chunk.getBlockZ();
        for (Map.Entry<BlockWorldVector, Set<PersistentMechanic>> entry : this.watchBlocks.entrySet()) {
            BlockWorldVector pos = entry.getKey();
            if (!pos.getWorld().equals((Object)chunk.getWorld())) continue;
            int curChunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
            int curChunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
            if (curChunkX != chunkX || curChunkZ != chunkZ) continue;
            folks.addAll((Collection<PersistentMechanic>)entry.getValue());
        }
        return folks;
    }
}

