/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.blockbag;

import com.sk89q.craftbook.blockbag.BlockBagFactory;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import org.bukkit.World;

public class DummyBlockBag
extends BlockBag {
    private boolean fetch = true;
    private boolean store = true;

    public DummyBlockBag() {
    }

    public DummyBlockBag(boolean fetch, boolean store) {
        this.fetch = fetch;
        this.store = store;
    }

    public void fetchBlock(int id) throws BlockBagException {
        if (!this.fetch) {
            throw new OutOfBlocksException();
        }
    }

    public void storeBlock(int id) throws BlockBagException {
        if (!this.store) {
            throw new OutOfSpaceException(id);
        }
    }

    public void addSourcePosition(WorldVector arg0) {
    }

    public void addSingleSourcePosition(WorldVector arg0) {
    }

    public void flushChanges() {
    }

    public static class UnlimitedSourceFactory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World w, Vector v) {
            return new DummyBlockBag(true, false);
        }
    }

    public static class BlackHoleFactory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World w, Vector v) {
            return new DummyBlockBag(false, true);
        }
    }

    public static class UnlimitedBlackHoleFactory
    implements BlockBagFactory {
        public BlockBag createBlockSource(World w, Vector v) {
            return new DummyBlockBag();
        }
    }
}

