/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.bukkit.util.CommandsManagerRegistration;
import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.LanguageManager;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.Injector;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.SimpleInjector;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.wepif.PermissionsResolverManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseBukkitPlugin
extends JavaPlugin {
    public BaseConfiguration config;
    private PermissionsResolverManager perms;
    protected LanguageManager languageManager;
    protected final CommandsManager<CommandSender> commands = new CommandsManager<CommandSender>(){

        public boolean hasPermission(CommandSender player, String perm) {
            return player.hasPermission(perm);
        }
    };
    private final CommandsManagerRegistration commandManager = new CommandsManagerRegistration((Plugin)this, this.commands);
    protected static final Logger logger = Logger.getLogger("Minecraft.CraftBook");

    public BaseBukkitPlugin() {
        this.commands.setInjector((Injector)new SimpleInjector(new Object[]{this}));
    }

    public void onLoad() {
    }

    public void onEnable() {
        this.getDataFolder().mkdirs();
        this.createDefaultConfiguration("en_US.txt", true);
        this.createDefaultConfiguration("config.yml", false);
        this.config = new BaseConfiguration(this.getConfig(), this.getDataFolder());
        this.saveConfig();
        LocationUtil.init(this);
        logger.info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " enabled.");
        PermissionsResolverManager.initialize((Plugin)this);
        this.perms = PermissionsResolverManager.getInstance();
    }

    public void onDisable() {
    }

    protected abstract void registerEvents();

    protected void registerEvents(Listener listener) {
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    protected void registerCommand(Class<?> clazz) {
        this.commandManager.register(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultConfiguration(String name, boolean force) {
        InputStream input;
        File actual = new File(this.getDataFolder(), name);
        if ((!actual.exists() || force) && (input = ((Object)((Object)this)).getClass().getResourceAsStream("/defaults/" + name)) != null) {
            FileOutputStream output = null;
            try {
                int length;
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                logger.info(this.getDescription().getName() + ": Default configuration file written: " + name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ignored) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException ignored) {}
            }
        }
    }

    public LocalPlayer wrap(Player player) {
        return new BukkitPlayer(this, player);
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (!(sender instanceof Player)) {
            return sender.isOp() && sender instanceof ConsoleCommandSender || this.perms.hasPermission(sender.getName(), perm);
        }
        return this.hasPermission(sender, ((Player)sender).getWorld(), perm);
    }

    public boolean hasPermission(CommandSender sender, World world, String perm) {
        if (sender.isOp() && this.config.commonSettings.opPerms || sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.perms.hasPermission(world.getName(), player.getName(), perm);
        }
        return false;
    }

    public boolean isInGroup(String player, String group) {
        return this.perms.inGroup(player, group);
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public BaseConfiguration getLocalConfiguration() {
        return this.config;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        try {
            this.commands.execute(cmd.getName(), args, (Object)sender, new Object[]{sender});
        }
        catch (CommandPermissionsException e) {
            sender.sendMessage(ChatColor.RED + "You don't have permission.");
        }
        catch (MissingNestedCommandException e) {
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (CommandUsageException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
            sender.sendMessage(ChatColor.RED + e.getUsage());
        }
        catch (WrappedCommandException e) {
            if (e.getCause() instanceof NumberFormatException) {
                sender.sendMessage(ChatColor.RED + "Number expected, string received instead.");
            } else {
                sender.sendMessage(ChatColor.RED + "An error has occurred. See console.");
                e.printStackTrace();
            }
        }
        catch (CommandException e) {
            sender.sendMessage(ChatColor.RED + e.getMessage());
        }
        return true;
    }
}

