/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitPlayer
implements LocalPlayer {
    protected final BaseBukkitPlugin plugin;
    protected final Player player;

    public Player getPlayer() {
        return this.player;
    }

    public BukkitPlayer(BaseBukkitPlugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void print(String message) {
        this.player.sendMessage(ChatColor.GOLD + this.plugin.getLanguageManager().getString(message));
    }

    public void printError(String message) {
        this.player.sendMessage(ChatColor.RED + this.plugin.getLanguageManager().getString(message));
    }

    public void printRaw(String message) {
        this.player.sendMessage(this.plugin.getLanguageManager().getString(message));
    }

    public boolean hasPermission(String perm) {
        return this.plugin.hasPermission((CommandSender)this.player, perm);
    }

    public void checkPermission(String perm) throws InsufficientPermissionsException {
        if (!this.hasPermission(perm)) {
            throw new InsufficientPermissionsException();
        }
    }

    public String getName() {
        return this.player.getName();
    }
}

