/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.MechanicManager;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.BlockWorldVector2D;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MechanicListenerAdapter {
    protected final BaseBukkitPlugin plugin;

    public MechanicListenerAdapter(BaseBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(MechanicManager manager) {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        MechanicPlayerListener playerListener = new MechanicPlayerListener(manager, this.plugin);
        MechanicBlockListener blockListener = new MechanicBlockListener(manager, this.plugin);
        MechanicWorldListener worldListener = new MechanicWorldListener(manager, this.plugin);
        pluginManager.registerEvents((Listener)playerListener, (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)blockListener, (Plugin)this.plugin);
        pluginManager.registerEvents((Listener)worldListener, (Plugin)this.plugin);
    }

    protected class MechanicWorldListener
    implements Listener {
        protected final MechanicManager manager;
        protected final BaseBukkitPlugin plugin;

        public MechanicWorldListener(MechanicManager manager, BaseBukkitPlugin plugin) {
            this.manager = manager;
            this.plugin = plugin;
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onChunkLoad(final ChunkLoadEvent event) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                public void run() {
                    MechanicWorldListener.this.manager.enumerate(event.getChunk());
                }
            }, 2L);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onChunkUnload(ChunkUnloadEvent event) {
            int chunkX = event.getChunk().getX();
            int chunkZ = event.getChunk().getZ();
            this.manager.unload(new BlockWorldVector2D(BukkitUtil.getLocalWorld((World)event.getWorld()), chunkX, chunkZ), event);
        }
    }

    protected static class MechanicBlockListener
    implements Listener {
        protected final MechanicManager manager;
        protected final BaseBukkitPlugin plugin;

        public MechanicBlockListener(MechanicManager manager, BaseBukkitPlugin plugin) {
            this.manager = manager;
            this.plugin = plugin;
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onSignChange(SignChangeEvent event) {
            this.manager.dispatchSignChange(event);
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onBlockBreak(BlockBreakEvent event) {
            this.manager.dispatchBlockBreak(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onBlockRedstoneChange(BlockRedstoneEvent event) {
            boolean wasChange;
            int oldLevel = event.getOldCurrent();
            int newLevel = event.getNewCurrent();
            Block block = event.getBlock();
            World world = block.getWorld();
            BlockWorldVector v = BukkitUtil.toWorldVector((Block)block);
            boolean wasOn = oldLevel >= 1;
            boolean isOn = newLevel >= 1;
            boolean bl = wasChange = wasOn != isOn;
            if (!wasChange) {
                return;
            }
            LocalWorld w = BukkitUtil.getLocalWorld((World)world);
            int x = v.getBlockX();
            int y = v.getBlockY();
            int z = v.getBlockZ();
            int type = block.getTypeId();
            if (type != 69 && type != 70 && type != 72 && type != 77 && type != 27 && type == 55) {
                if (this.plugin.getConfig().getBoolean("allow-indirect-redstone", false)) {
                    this.handleDirectWireInput(new WorldVector(w, x - 1, y, z), isOn, block, oldLevel, newLevel);
                    this.handleDirectWireInput(new WorldVector(w, x, y - 1, z), isOn, block, oldLevel, newLevel);
                    this.handleDirectWireInput(new WorldVector(w, x + 1, y, z), isOn, block, oldLevel, newLevel);
                    this.handleDirectWireInput(new WorldVector(w, x, y + 1, z), isOn, block, oldLevel, newLevel);
                } else {
                    int above = world.getBlockTypeIdAt(x, y + 1, z);
                    int westSide = world.getBlockTypeIdAt(x, y, z + 1);
                    int westSideAbove = world.getBlockTypeIdAt(x, y + 1, z + 1);
                    int westSideBelow = world.getBlockTypeIdAt(x, y - 1, z + 1);
                    int eastSide = world.getBlockTypeIdAt(x, y, z - 1);
                    int eastSideAbove = world.getBlockTypeIdAt(x, y + 1, z - 1);
                    int eastSideBelow = world.getBlockTypeIdAt(x, y - 1, z - 1);
                    int northSide = world.getBlockTypeIdAt(x - 1, y, z);
                    int northSideAbove = world.getBlockTypeIdAt(x - 1, y + 1, z);
                    int northSideBelow = world.getBlockTypeIdAt(x - 1, y - 1, z);
                    int southSide = world.getBlockTypeIdAt(x + 1, y, z);
                    int southSideAbove = world.getBlockTypeIdAt(x + 1, y + 1, z);
                    int southSideBelow = world.getBlockTypeIdAt(x + 1, y - 1, z);
                    if (!(BlockType.isRedstoneBlock((int)westSide) || BlockType.isRedstoneBlock((int)eastSide) || BlockType.isRedstoneBlock((int)westSideAbove) && westSide != 0 && above == 0 || BlockType.isRedstoneBlock((int)eastSideAbove) && eastSide != 0 && above == 0 || BlockType.isRedstoneBlock((int)westSideBelow) && westSide == 0 || BlockType.isRedstoneBlock((int)eastSideBelow) && eastSide == 0)) {
                        this.handleDirectWireInput(new WorldVector(w, x - 1, y, z), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x + 1, y, z), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x - 1, y - 1, z), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x + 1, y - 1, z), isOn, block, oldLevel, newLevel);
                    }
                    if (!(BlockType.isRedstoneBlock((int)northSide) || BlockType.isRedstoneBlock((int)southSide) || BlockType.isRedstoneBlock((int)northSideAbove) && northSide != 0 && above == 0 || BlockType.isRedstoneBlock((int)southSideAbove) && southSide != 0 && above == 0 || BlockType.isRedstoneBlock((int)northSideBelow) && northSide == 0 || BlockType.isRedstoneBlock((int)southSideBelow) && southSide == 0)) {
                        this.handleDirectWireInput(new WorldVector(w, x, y, z - 1), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x, y, z + 1), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x, y - 1, z - 1), isOn, block, oldLevel, newLevel);
                        this.handleDirectWireInput(new WorldVector(w, x, y - 1, z + 1), isOn, block, oldLevel, newLevel);
                    }
                }
                this.handleDirectWireInput(new WorldVector(w, x, y + 1, z), isOn, block, oldLevel, newLevel);
                return;
            }
            this.handleDirectWireInput(new WorldVector(w, x - 1, y, z), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x + 1, y, z), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x - 1, y - 1, z), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x + 1, y - 1, z), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x, y, z - 1), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x, y, z + 1), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x, y - 1, z - 1), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x, y - 1, z + 1), isOn, block, oldLevel, newLevel);
            this.handleDirectWireInput(new WorldVector(w, x, y + 1, z), isOn, block, oldLevel, newLevel);
        }

        protected void handleDirectWireInput(WorldVector pt, boolean isOn, Block sourceBlock, int oldLevel, int newLevel) {
            Block block = ((BukkitWorld)pt.getWorld()).getWorld().getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            this.manager.dispatchBlockRedstoneChange(new SourcedBlockRedstoneEvent(sourceBlock, block, oldLevel, newLevel));
        }
    }

    protected static class MechanicPlayerListener
    implements Listener {
        protected final MechanicManager manager;
        protected final BaseBukkitPlugin plugin;

        public MechanicPlayerListener(MechanicManager manager, BaseBukkitPlugin plugin) {
            this.manager = manager;
            this.plugin = plugin;
        }

        @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                this.manager.dispatchBlockRightClick(event);
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                this.manager.dispatchBlockLeftClick(event);
            }
        }
    }
}

