/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.util;

import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ItemUtil {
    public static boolean areItemsSimilar(ItemStack item, ItemStack item2) {
        return item.getTypeId() == item2.getTypeId();
    }

    public static boolean areItemsIdentical(ItemStack item, ItemStack item2) {
        return item.getTypeId() == item2.getTypeId() && item.getData() == item2.getData();
    }

    public static boolean isItemSimilarTo(ItemStack item, int type) {
        return item.getTypeId() == type;
    }

    public static boolean isItemIdenticalTo(ItemStack item, int type, byte data) {
        return item.getTypeId() == type && item.getData().getData() == data;
    }

    public static void setItemTypeAndData(ItemStack item, int type, byte data) {
        item.setTypeId(type);
        item.setData(new MaterialData(type, data));
    }

    public static boolean isStackValid(ItemStack item) {
        return item != null && item.getAmount() > 0 && item.getTypeId() > 0;
    }

    public static boolean isCookable(ItemStack item) {
        return ItemUtil.getCookedResult(item) != null;
    }

    public static ItemStack getCookedResult(ItemStack item) {
        switch (item.getTypeId()) {
            case 363: {
                return new ItemStack(364);
            }
            case 365: {
                return new ItemStack(366);
            }
            case 349: {
                return new ItemStack(350);
            }
            case 319: {
                return new ItemStack(320);
            }
        }
        return null;
    }

    public static boolean isSmeltable(ItemStack item) {
        return ItemUtil.getSmeletedResult(item) != null;
    }

    public static ItemStack getSmeletedResult(ItemStack item) {
        switch (item.getTypeId()) {
            case 15: {
                return new ItemStack(265);
            }
            case 14: {
                return new ItemStack(266);
            }
            case 56: {
                return new ItemStack(264);
            }
            case 12: {
                return new ItemStack(20);
            }
            case 337: {
                return new ItemStack(336);
            }
        }
        return null;
    }

    public static boolean containsRawFood(Inventory inv) {
        for (ItemStack it : inv.getContents()) {
            if (it == null || !ItemUtil.isCookable(it)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsRawMinerals(Inventory inv) {
        for (ItemStack it : inv.getContents()) {
            if (it == null || !ItemUtil.isSmeltable(it)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEdible(ItemStack item) {
        return item.getType().isEdible();
    }

    public static ItemStack getUsedItem(ItemStack item) {
        if (item.getTypeId() == 282) {
            item.setTypeId(281);
        } else if (item.getTypeId() == 373) {
            item.setTypeId(374);
        } else if (item.getTypeId() == 327 || item.getTypeId() == 326 || item.getTypeId() == 335) {
            item.setTypeId(325);
        } else if (item.getAmount() == 1) {
            item.setTypeId(0);
        } else {
            item.setAmount(item.getAmount() - 1);
        }
        return item;
    }
}

