/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.mech.CustomDropManager;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;

public class MechanismsConfiguration
extends BaseConfiguration {
    public final File dataFolder;
    public final MechanismSettings mechSettings;
    public final AmmeterSettings ammeterSettings;
    public final BookcaseSettings bookcaseSettings;
    public final BridgeSettings bridgeSettings;
    public final DoorSettings doorSettings;
    public final GateSettings gateSettings;
    public final ElevatorSettings elevatorSettings;
    public final TeleporterSettings teleporterSettings;
    public final CauldronSettings cauldronSettings;
    public final LightStoneSettings lightStoneSettings;
    public final LightSwitchSettings lightSwitchSettings;
    public final HiddenSwitchSettings hiddenSwitchSettings;
    public final SnowSettings snowSettings;
    public final AreaSettings areaSettings;
    public final CommandSettings commandSettings;
    public final CustomDropManager customDrops;
    public final CustomDropSettings customDropSettings;
    public final DispenserSettings dispenserSettings;
    public final ChairSettings chairSettings;
    public final AISettings aiSettings;
    public final AnchorSettings anchorSettings;
    public final CookingPotSettings cookingPotSettings;
    public final CustomCraftingSettings customCraftingSettings;
    public final PaintingSettings paintingSettings;

    public MechanismsConfiguration(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
        this.dataFolder = dataFolder;
        this.mechSettings = new MechanismSettings();
        this.ammeterSettings = new AmmeterSettings();
        this.bookcaseSettings = new BookcaseSettings();
        this.bridgeSettings = new BridgeSettings();
        this.doorSettings = new DoorSettings();
        this.gateSettings = new GateSettings();
        this.elevatorSettings = new ElevatorSettings();
        this.teleporterSettings = new TeleporterSettings();
        this.cauldronSettings = new CauldronSettings();
        this.lightStoneSettings = new LightStoneSettings();
        this.lightSwitchSettings = new LightSwitchSettings();
        this.hiddenSwitchSettings = new HiddenSwitchSettings();
        this.snowSettings = new SnowSettings();
        this.areaSettings = new AreaSettings();
        this.commandSettings = new CommandSettings();
        this.customDrops = new CustomDropManager(dataFolder);
        this.customDropSettings = new CustomDropSettings();
        this.dispenserSettings = new DispenserSettings();
        this.chairSettings = new ChairSettings();
        this.aiSettings = new AISettings();
        this.anchorSettings = new AnchorSettings();
        this.cookingPotSettings = new CookingPotSettings();
        this.customCraftingSettings = new CustomCraftingSettings();
        this.paintingSettings = new PaintingSettings();
    }

    public class PaintingSettings {
        public final boolean enabled;

        private PaintingSettings() {
            this.enabled = MechanismsConfiguration.this.getBoolean("painting-switch-enable", true);
        }
    }

    public class AISettings {
        public final boolean enabled;
        public final boolean zombieVision;

        private AISettings() {
            this.enabled = MechanismsConfiguration.this.getBoolean("ai-mechanic-enable", true);
            this.zombieVision = MechanismsConfiguration.this.getBoolean("realistic-zombie-vision", true);
        }
    }

    public class ChairSettings {
        public final boolean enable;
        public final boolean requireSneak;
        public final Set<Material> allowedBlocks;
        public Map<String, Block> chairs = new HashMap<String, Block>();

        private ChairSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("chair-enable", true);
            this.requireSneak = MechanismsConfiguration.this.getBoolean("chair-sneaking", true);
            this.allowedBlocks = MechanismsConfiguration.this.getMaterialSet("chair-blocks", Arrays.asList(53, 67, 108, 109, 114, 128, 134, 135, 136));
        }

        public boolean canUseBlock(Material b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class CustomDropSettings {
        public final boolean enable;
        public final boolean requirePermissions;

        private CustomDropSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("custom-drops-enable", true);
            this.requirePermissions = MechanismsConfiguration.this.getBoolean("custom-drops-require-permissions", false);
        }
    }

    public class AreaSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxAreasPerUser;
        public final int maxSizePerArea;
        public final boolean useSchematics;

        private AreaSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("area-enable", true);
            this.enableRedstone = MechanismsConfiguration.this.getBoolean("area-redstone", true);
            this.maxAreasPerUser = MechanismsConfiguration.this.getInt("max-areas-per-user", 30);
            this.maxSizePerArea = MechanismsConfiguration.this.getInt("max-size-per-area", 5000);
            this.useSchematics = MechanismsConfiguration.this.getBoolean("area-use-schematic", true);
        }
    }

    public class SnowSettings {
        public final boolean enable;
        public final boolean trample;
        public final boolean placeSnow;
        public final boolean jumpTrample;
        public final boolean piling;

        private SnowSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("snow-piling-enable", true);
            this.trample = MechanismsConfiguration.this.getBoolean("snow-trample-enable", true);
            this.placeSnow = MechanismsConfiguration.this.getBoolean("placable-snow", true);
            this.jumpTrample = MechanismsConfiguration.this.getBoolean("jump-trample-only", true);
            this.piling = MechanismsConfiguration.this.getBoolean("snow-piles-high", false);
        }
    }

    public class HiddenSwitchSettings {
        public final boolean enable;

        private HiddenSwitchSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("hidden-switches-enable", true);
        }
    }

    public class AmmeterSettings {
        public final boolean enable;

        private AmmeterSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("ammeter-enable", true);
        }
    }

    public class LightStoneSettings {
        public final boolean enable;

        private LightStoneSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("light-stone-enable", true);
        }
    }

    public class LightSwitchSettings {
        public final boolean enable;
        public final int maxRange;
        public final int maxMaximum;

        private LightSwitchSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("light-switch-enable", true);
            this.maxRange = MechanismsConfiguration.this.getInt("light-switch-max-range", 10);
            this.maxMaximum = MechanismsConfiguration.this.getInt("light-switch-max-lights", 20);
        }
    }

    public class CauldronSettings {
        public final boolean enable;
        public final int cauldronBlock;
        public final boolean enableNew;
        public final boolean newSpoons;

        private CauldronSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("cauldron-enable", false);
            this.cauldronBlock = MechanismsConfiguration.this.getInt("cauldron-block", 1);
            this.enableNew = MechanismsConfiguration.this.getBoolean("new-cauldron-enable", true);
            this.newSpoons = MechanismsConfiguration.this.getBoolean("new-cauldron-spoons", true);
        }
    }

    public class TeleporterSettings {
        public final boolean enable;

        private TeleporterSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("teleporter-enable", true);
        }
    }

    public class ElevatorSettings {
        public final boolean enable;

        private ElevatorSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("elevators-enable", true);
        }
    }

    public class CommandSettings {
        public final boolean enable;

        private CommandSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("command-sign-enable", true);
        }
    }

    public class GateSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final Set<Integer> allowedBlocks;

        private GateSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("gate-enable", true);
            this.enableRedstone = MechanismsConfiguration.this.getBoolean("gate-redstone", true);
            this.allowedBlocks = MechanismsConfiguration.this.getIntegerSet("gate-blocks", Arrays.asList(85, 101, 102, 113));
        }

        public boolean canUseBlock(int b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class DoorSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxLength;
        public final int maxWidth;
        public final Set<Integer> allowedBlocks;

        private DoorSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("door-enable", true);
            this.enableRedstone = MechanismsConfiguration.this.getBoolean("door-redstone", true);
            this.maxLength = MechanismsConfiguration.this.getInt("door-max-length", 30);
            this.maxWidth = MechanismsConfiguration.this.getInt("door-max-width", 5);
            this.allowedBlocks = MechanismsConfiguration.this.getIntegerSet("door-blocks", Arrays.asList(4, 5, 20, 43));
        }

        public boolean canUseBlock(int b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class BridgeSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxLength;
        public final int maxWidth;
        public final Set<Material> allowedBlocks;

        private BridgeSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("bridge-enable", true);
            this.enableRedstone = MechanismsConfiguration.this.getBoolean("bridge-redstone", true);
            this.maxLength = MechanismsConfiguration.this.getInt("bridge-max-length", 30);
            this.maxWidth = MechanismsConfiguration.this.getInt("bridge-max-width", 5);
            this.allowedBlocks = MechanismsConfiguration.this.getMaterialSet("bridge-blocks", Arrays.asList(4, 5, 20, 43));
        }

        public boolean canUseBlock(Material b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class BookcaseSettings {
        public final boolean enable;
        public final String readLine;

        private BookcaseSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("bookshelf-enable", true);
            this.readLine = MechanismsConfiguration.this.getString("bookshelf-read-text", "You pick up a book...");
        }
    }

    public class CookingPotSettings {
        public final boolean enable;

        private CookingPotSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("cooking-pot-enable", true);
        }
    }

    public class CustomCraftingSettings {
        public final boolean enable;

        private CustomCraftingSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("custom-crafting-enable", true);
        }
    }

    public class AnchorSettings {
        public final boolean enable;

        private AnchorSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("chunk-anchor-enable", true);
        }
    }

    public class DispenserSettings {
        public final boolean enable;

        private DispenserSettings() {
            this.enable = MechanismsConfiguration.this.getBoolean("dispenser-recipes-enable", true);
        }
    }

    public class MechanismSettings {
        public final boolean stopDestruction;

        private MechanismSettings() {
            this.stopDestruction = MechanismsConfiguration.this.getBoolean("stop-mechanism-dupe", false);
        }
    }
}

