/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Bookcase
extends AbstractMechanic {
    protected static Random rand = new Random();
    protected final MechanismsPlugin plugin;

    public Bookcase(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void read(LocalPlayer player, String bookReadLine) {
        if (!player.hasPermission("craftbook.mech.bookshelf.use")) {
            return;
        }
        try {
            String text = this.getBookLine();
            if (text != null) {
                player.print(bookReadLine);
                player.printRaw(text);
            } else {
                player.printError("Failed to fetch a line from the books file.");
            }
        }
        catch (IOException e) {
            player.printError("Failed to read the books file.");
        }
    }

    protected String getBookLine() throws IOException {
        String line;
        LineNumberReader lnr = new LineNumberReader(new FileReader(new File(this.plugin.getLocalConfiguration().dataFolder, "books.txt")));
        lnr.skip(Long.MAX_VALUE);
        int lines = lnr.getLineNumber();
        lnr.close();
        int toRead = new Random().nextInt(lines);
        BufferedReader br = new BufferedReader(new FileReader(new File(this.plugin.getLocalConfiguration().dataFolder, "books.txt")));
        int passes = 0;
        while ((line = br.readLine()) != null && ++passes < toRead) {
        }
        br.close();
        return line;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().bookcaseSettings.enable) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getItemInHand() == null || player.getItemInHand().getTypeId() == 0 || !player.getItemInHand().getType().isBlock()) {
            this.read(this.plugin.wrap(player), this.plugin.getLocalConfiguration().bookcaseSettings.readLine);
        }
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Bookcase> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Bookcase detect(BlockWorldVector pt) {
            if (pt.getWorld().getBlockType((Vector)pt) == 47) {
                return new Bookcase(pt, this.plugin);
            }
            return null;
        }
    }
}

