/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.MechanismsConfiguration;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Bridge
extends AbstractMechanic {
    private MechanismsPlugin plugin;
    private MechanismsConfiguration.BridgeSettings settings;
    private Block trigger;
    private Block proximalBaseCenter;
    private Block farSide;
    private CuboidRegion toggle;

    private Bridge(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        int i;
        int right;
        int left;
        String otherSignText;
        if (!SignUtil.isCardinal((Block)trigger)) {
            throw new InvalidDirectionException();
        }
        BlockFace dir = SignUtil.getFacing((Block)trigger);
        this.trigger = trigger;
        this.plugin = plugin;
        this.settings = plugin.getLocalConfiguration().bridgeSettings;
        Sign s = (Sign)trigger.getState();
        this.proximalBaseCenter = trigger.getRelative(BlockFace.UP);
        Material mat = this.proximalBaseCenter.getType();
        if (!this.settings.canUseBlock(mat) || !this.isValidBridge(this.proximalBaseCenter, mat, s)) {
            this.proximalBaseCenter = trigger.getRelative(BlockFace.DOWN);
            mat = this.proximalBaseCenter.getType();
            if (this.settings.canUseBlock(mat)) {
                if (!this.isValidBridge(this.proximalBaseCenter, mat, s)) {
                    throw new InvalidConstructionException("mech.bridge.material");
                }
            } else {
                throw new UnacceptableMaterialException();
            }
        }
        this.farSide = trigger.getRelative(dir);
        for (int i2 = 0; i2 <= this.settings.maxLength && (this.farSide.getType() != Material.SIGN_POST || !"[Bridge]".equalsIgnoreCase(otherSignText = ((Sign)this.farSide.getState()).getLine(1)) && !"[Bridge End]".equalsIgnoreCase(otherSignText)); ++i2) {
            this.farSide = this.farSide.getRelative(dir);
        }
        if (this.farSide.getType() != Material.SIGN_POST) {
            throw new InvalidConstructionException("mech.bridge.other-sign");
        }
        Block distalBaseCenter = this.farSide.getRelative(trigger.getFace(this.proximalBaseCenter));
        if (distalBaseCenter.getType() != mat && distalBaseCenter.getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getType() != mat && distalBaseCenter.getRelative(SignUtil.getLeft((Block)trigger)).getData() != this.proximalBaseCenter.getData() || distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getType() != mat && distalBaseCenter.getRelative(SignUtil.getRight((Block)trigger)).getData() != this.proximalBaseCenter.getData()) {
            throw new InvalidConstructionException("mech.bridge.material");
        }
        this.toggle = new CuboidRegion((Vector)BukkitUtil.toVector((Block)this.proximalBaseCenter), (Vector)BukkitUtil.toVector((Block)distalBaseCenter));
        try {
            left = Integer.parseInt(s.getLine(2));
            if (left < 0) {
                left = 0;
            }
        }
        catch (Exception ignored) {
            left = 1;
        }
        try {
            right = Integer.parseInt(s.getLine(3));
            if (right < 0) {
                right = 0;
            }
        }
        catch (Exception ignored) {
            right = 1;
        }
        if (left > this.settings.maxWidth) {
            left = this.settings.maxWidth;
        }
        if (right > this.settings.maxWidth) {
            right = this.settings.maxWidth;
        }
        for (i = 0; i < left; ++i) {
            try {
                this.toggle.expand((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getLeft((Block)trigger)));
                continue;
            }
            catch (RegionOperationException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < right; ++i) {
            try {
                this.toggle.expand((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getRight((Block)trigger)));
                continue;
            }
            catch (RegionOperationException e) {
                e.printStackTrace();
            }
        }
        this.toggle.contract(new Vector[]{BukkitUtil.toVector((BlockFace)SignUtil.getBack((Block)trigger)), BukkitUtil.toVector((BlockFace)SignUtil.getFront((Block)trigger))});
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer((BaseBukkitPlugin)this.plugin, event.getPlayer());
        if (!player.hasPermission("craftbook.mech.bridge.use")) {
            player.printError("mech.use-permission");
            return;
        }
        if (event.getPlayer().getItemInHand() != null && this.getBridgeMaterial().getId() == event.getPlayer().getItemInHand().getTypeId()) {
            BlockState state;
            Sign sign = null;
            if ((event.getClickedBlock().getTypeId() == 63 || event.getClickedBlock().getTypeId() == 68) && (state = event.getClickedBlock().getState()) instanceof Sign) {
                sign = (Sign)state;
            }
            if (sign != null) {
                try {
                    int newBlocks = Integer.parseInt(sign.getLine(0)) + 1;
                    sign.setLine(0, newBlocks + "");
                    sign.update();
                }
                catch (Exception e) {
                    sign.setLine(0, "1");
                    sign.update();
                }
                if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
                    if (event.getPlayer().getItemInHand().getAmount() <= 1) {
                        event.getPlayer().setItemInHand(new ItemStack(0, 0));
                    } else {
                        event.getPlayer().getItemInHand().setAmount(event.getPlayer().getItemInHand().getAmount() - 1);
                    }
                }
                player.print("mech.restock");
                event.setCancelled(true);
                return;
            }
        }
        this.flipState((LocalPlayer)player);
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enableRedstone) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (event.getNewCurrent() == 0) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionOpen(), 2L);
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionClosed(null), 2L);
        }
    }

    private void flipState(LocalPlayer player) {
        Block hinge = this.proximalBaseCenter.getRelative(SignUtil.getFacing((Block)this.trigger));
        if (Bridge.canPassThrough(hinge.getTypeId())) {
            new ToggleRegionClosed(player).run();
        } else {
            new ToggleRegionOpen().run();
        }
    }

    private Material getBridgeMaterial() {
        return this.proximalBaseCenter.getType();
    }

    private byte getBridgeData() {
        return this.proximalBaseCenter.getData();
    }

    public boolean isValidBridge(Block baseCenter, Material mat, Sign s) throws InvalidMechanismException {
        if (!s.getLine(2).equalsIgnoreCase("0") ? this.proximalBaseCenter.getRelative(SignUtil.getLeft((Block)this.trigger)).getType() != mat : this.proximalBaseCenter.getType() != mat) {
            return false;
        }
        return !(!s.getLine(3).equalsIgnoreCase("0") ? this.proximalBaseCenter.getRelative(SignUtil.getRight((Block)this.trigger)).getType() != mat : this.proximalBaseCenter.getType() != mat);
    }

    private static boolean canPassThrough(int t) {
        int[] passableBlocks = new int[]{8, 9, 10, 11, 85, 78, 31, 106, 32, 0};
        for (int aPassableBlock : passableBlocks) {
            if (aPassableBlock != t) continue;
            return true;
        }
        return false;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
        BlockState state;
        Sign sign = null;
        if (event.getBlock().getTypeId() == 68 && (state = event.getBlock().getState()) instanceof Sign) {
            sign = (Sign)state;
        }
        int curBlocks = 0;
        if (sign != null && sign.getLine(0).length() > 0) {
            try {
                curBlocks = Integer.parseInt(sign.getLine(0));
            }
            catch (Exception e) {
                curBlocks = 0;
                sign.setLine(0, "0");
                sign.update();
            }
        }
        if (curBlocks > 0) {
            ItemStack toDrop = new ItemStack(this.getBridgeMaterial(), curBlocks, (short)this.getBridgeData());
            if (sign != null) {
                sign.getWorld().dropItemNaturally(sign.getLocation(), toDrop);
            }
        }
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 8758644926222590049L;

        public InvalidConstructionException(String msg) {
            super(msg);
        }
    }

    private static class UnacceptableMaterialException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -2856504362189922160L;

        private UnacceptableMaterialException() {
        }
    }

    private static class InvalidDirectionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -8169241147023551662L;

        private InvalidDirectionException() {
        }
    }

    private class ToggleRegionClosed
    implements Runnable {
        final LocalPlayer player;

        public ToggleRegionClosed(LocalPlayer player) {
            this.player = player;
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                if (!Bridge.canPassThrough(b.getTypeId())) continue;
                if (((Bridge)Bridge.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) {
                    int curBlocks;
                    Sign s = (Sign)Bridge.this.trigger.getState();
                    try {
                        curBlocks = Integer.parseInt(s.getLine(0));
                    }
                    catch (NumberFormatException e) {
                        curBlocks = 0;
                    }
                    if (curBlocks > 0) {
                        b.setType(Bridge.this.getBridgeMaterial());
                        b.setData(Bridge.this.getBridgeData());
                        s.setLine(0, --curBlocks + "");
                        s.update();
                        continue;
                    }
                    if (this.player != null) {
                        this.player.printError("Not enough blocks for mechanic to function!");
                    }
                    return;
                }
                b.setType(Bridge.this.getBridgeMaterial());
                b.setData(Bridge.this.getBridgeData());
            }
        }
    }

    private class ToggleRegionOpen
    implements Runnable {
        private ToggleRegionOpen() {
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                int curBlocks;
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                int oldType = 0;
                if (b != null) {
                    oldType = b.getTypeId();
                }
                if (b.getType() != Bridge.this.getBridgeMaterial() && !Bridge.canPassThrough(b.getTypeId())) continue;
                b.setType(Material.AIR);
                if (!((Bridge)Bridge.this).plugin.getLocalConfiguration().mechSettings.stopDestruction) continue;
                Sign s = (Sign)Bridge.this.trigger.getState();
                try {
                    curBlocks = Integer.parseInt(s.getLine(0));
                }
                catch (NumberFormatException e) {
                    curBlocks = 0;
                }
                if (oldType != 0) {
                    ++curBlocks;
                }
                s.setLine(0, curBlocks + "");
                s.update();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Bridge> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Bridge detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 63) {
                return null;
            }
            if (!((Sign)block.getState()).getLine(1).equalsIgnoreCase("[Bridge]")) {
                return null;
            }
            return new Bridge(block, this.plugin);
        }

        public Bridge detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Bridge]")) {
                player.checkPermission("craftbook.mech.bridge");
                sign.setLine(1, "[Bridge]");
                sign.setLine(0, "0");
                sign.update();
                player.print("mech.bridge.create");
            } else if (sign.getLine(1).equalsIgnoreCase("[Bridge End]")) {
                player.checkPermission("craftbook.mech.bridge");
                sign.setLine(1, "[Bridge End]");
                sign.setLine(0, "0");
                sign.update();
                player.print("mech.bridge.end-create");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

