/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.CauldronCookbook;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Cauldron
extends AbstractMechanic {
    private final CauldronCookbook recipes;
    private final BlockWorldVector pt;
    private final MechanismsPlugin plugin;

    public Cauldron(CauldronCookbook recipes, BlockWorldVector pt, MechanismsPlugin plugin) {
        this.recipes = recipes;
        this.pt = pt;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!this.plugin.getLocalConfiguration().cauldronSettings.enable) {
            return;
        }
        if (!localPlayer.hasPermission("craftbook.mech.cauldron")) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)this.pt)) {
            return;
        }
        if ((event.getPlayer().getItemInHand().getTypeId() >= 255 || event.getPlayer().getItemInHand().getType() == Material.AIR) && this.preCauldron(event.getPlayer(), event.getPlayer().getWorld(), this.pt)) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    public boolean preCauldron(Player player, World world, BlockWorldVector pt) {
        double x = pt.getX();
        double y = pt.getY();
        double z = pt.getZ();
        int ix = pt.getBlockX();
        int iy = pt.getBlockY();
        int iz = pt.getBlockZ();
        double rootY = y;
        int below = world.getBlockTypeIdAt(ix, iy - 1, iz);
        int below2 = world.getBlockTypeIdAt(ix, iy - 2, iz);
        int s1 = world.getBlockTypeIdAt(ix + 1, iy, iz);
        int s3 = world.getBlockTypeIdAt(ix - 1, iy, iz);
        int s2 = world.getBlockTypeIdAt(ix, iy, iz + 1);
        int s4 = world.getBlockTypeIdAt(ix, iy, iz - 1);
        int blockID = this.plugin.getLocalConfiguration().cauldronSettings.cauldronBlock;
        if (below == 11) {
            below = 10;
        }
        if (below2 == 11) {
            below2 = 10;
        }
        if (!(below != 10 && below2 != 10 || s1 != blockID && s2 != blockID && s3 != blockID && s4 != blockID)) {
            if (below == 10) {
                rootY += 1.0;
            }
            this.performCauldron(player, world, new BlockWorldVector(pt.getWorld(), x, rootY, z));
            return true;
        }
        return false;
    }

    private void performCauldron(Player player, World world, BlockWorldVector pt) {
        int rootY = pt.getBlockY();
        int blockID = this.plugin.getLocalConfiguration().cauldronSettings.cauldronBlock;
        HashMap<BlockWorldVector, Integer> visited = new HashMap<BlockWorldVector, Integer>();
        try {
            this.findCauldronContents(world, pt, rootY - 1, rootY, visited);
            if (visited.size() != 24) {
                throw new NotACauldronException("mech.cauldron.too-small");
            }
            HashMap<Integer, Integer> contents = new HashMap<Integer, Integer>();
            for (Map.Entry entry : visited.entrySet()) {
                if ((Integer)entry.getValue() == blockID) continue;
                if (!contents.containsKey(entry.getValue())) {
                    contents.put((Integer)entry.getValue(), 1);
                    continue;
                }
                contents.put((Integer)entry.getValue(), (Integer)contents.get(entry.getValue()) + 1);
            }
            CauldronCookbook.Recipe recipe = this.recipes.find(contents);
            if (recipe != null) {
                String[] groups = recipe.getGroups();
                if (groups != null) {
                    boolean found = false;
                    int i$ = 0;
                    String[] arr$ = groups;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        String group = arr$[i$];
                        found = true;
                    }
                    if (!found) {
                        player.sendMessage(ChatColor.DARK_RED + "Doesn't seem as if you have the ability...");
                        return;
                    }
                }
                player.sendMessage(ChatColor.GOLD + "In a poof of smoke, you've made " + recipe.getName() + ".");
                ArrayList<Integer> ingredients = new ArrayList<Integer>(recipe.getIngredients());
                ArrayList removeQueue = new ArrayList();
                for (Map.Entry entry : visited.entrySet()) {
                    if (!ingredients.contains(entry.getValue())) continue;
                    world.getBlockAt(((BlockWorldVector)entry.getKey()).getBlockX(), ((BlockWorldVector)entry.getKey()).getBlockY(), ((BlockWorldVector)entry.getKey()).getBlockZ()).setType(Material.AIR);
                    ingredients.remove(entry.getValue());
                }
                for (BlockWorldVector v : removeQueue) {
                    world.getBlockAt(v.getBlockX(), v.getBlockY(), v.getBlockZ()).setType(Material.AIR);
                }
                for (Integer id : recipe.getResults()) {
                    HashMap map = player.getInventory().addItem(new ItemStack[]{new ItemStack(id.intValue(), 1)});
                    for (Map.Entry i : map.entrySet()) {
                        world.dropItem(player.getLocation(), (ItemStack)i.getValue());
                    }
                }
            } else {
                player.sendMessage(ChatColor.RED + "Hmm, this doesn't make anything...");
            }
        }
        catch (NotACauldronException ignored) {
            // empty catch block
        }
    }

    public void findCauldronContents(World world, BlockWorldVector pt, int minY, int maxY, Map<BlockWorldVector, Integer> visited) throws NotACauldronException {
        int blockID = this.plugin.getLocalConfiguration().cauldronSettings.cauldronBlock;
        if (pt.getBlockY() < minY) {
            return;
        }
        if (pt.getBlockY() > maxY) {
            return;
        }
        if (visited.size() > 24) {
            throw new NotACauldronException("mech.cauldron.leaky");
        }
        if (visited.containsKey(pt)) {
            return;
        }
        int type = world.getBlockTypeIdAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (type == 9) {
            type = 8;
        }
        if (type == 11) {
            type = 10;
        }
        visited.put(pt, type);
        if (type == blockID) {
            return;
        }
        BlockWorldVector lavaPos = this.recurse(0, pt.getBlockY() - minY + 1, 0, pt);
        if (world.getBlockTypeIdAt(lavaPos.getBlockX(), lavaPos.getBlockY(), lavaPos.getBlockZ()) == 10) {
            throw new NotACauldronException("mech.cauldron.no-lava");
        }
        this.findCauldronContents(world, this.recurse(1, 0, 0, pt), minY, maxY, visited);
        this.findCauldronContents(world, this.recurse(-1, 0, 0, pt), minY, maxY, visited);
        this.findCauldronContents(world, this.recurse(0, 0, 1, pt), minY, maxY, visited);
        this.findCauldronContents(world, this.recurse(0, 0, -1, pt), minY, maxY, visited);
        this.findCauldronContents(world, this.recurse(0, 1, 0, pt), minY, maxY, visited);
        this.findCauldronContents(world, this.recurse(0, -1, 0, pt), minY, maxY, visited);
    }

    private BlockWorldVector recurse(int i, int j, int k, BlockWorldVector pt) {
        return new BlockWorldVector(pt.getWorld(), pt.getX() + (double)i, pt.getY() + (double)j, pt.getZ() + (double)k);
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    private class NotACauldronException
    extends Exception {
        private static final long serialVersionUID = 3091428924893050849L;

        public NotACauldronException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Cauldron> {
        protected final MechanismsPlugin plugin;
        protected final CauldronCookbook recipes;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
            this.recipes = new CauldronCookbook();
        }

        public Cauldron detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() == 0) {
                return null;
            }
            return new Cauldron(this.recipes, pt, this.plugin);
        }
    }
}

