/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CauldronCookbook {
    private final List<Recipe> recipes = new ArrayList<Recipe>();
    static final Logger log = Logger.getLogger("Minecraft");

    public CauldronCookbook() {
        try {
            CauldronCookbook recipes = this.readCauldronRecipes("cauldron-recipes.txt");
            if (recipes.size() != 0) {
                log.info(recipes.size() + " cauldron recipe(s) loaded");
            } else {
                log.warning("cauldron-recipes.txt had no recipes");
            }
        }
        catch (FileNotFoundException e) {
            log.info("cauldron-recipes.txt not found: " + e.getMessage());
            try {
                log.info("Looked in: " + new File(".").getCanonicalPath() + "/plugins/CraftBookMechanisms");
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            log.warning("cauldron-recipes.txt not loaded: " + e.getMessage());
        }
    }

    public void add(Recipe recipe) {
        this.recipes.add(recipe);
    }

    public Recipe find(Map<Integer, Integer> ingredients) {
        for (Recipe recipe : this.recipes) {
            if (!recipe.hasAllIngredients(ingredients)) continue;
            return recipe;
        }
        return null;
    }

    public int size() {
        return this.recipes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CauldronCookbook readCauldronRecipes(String path) throws IOException {
        File file = new File("plugins/CraftBookMechanisms", path);
        FileReader input = null;
        try {
            String line;
            input = new FileReader(file);
            BufferedReader buff = new BufferedReader(input);
            while ((line = buff.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.charAt(0) == ';' || line.charAt(0) == '#' || line.equals("")) continue;
                String[] parts = line.split(":");
                if (parts.length < 3) {
                    log.log(Level.WARNING, "Invalid cauldron recipe line in " + file.getName() + ": '" + line + "'");
                    continue;
                }
                String name = parts[0];
                List<Integer> ingredients = this.parseCauldronItems(parts[1]);
                List<Integer> results = this.parseCauldronItems(parts[2]);
                String[] groups = null;
                if (parts.length >= 4 && parts[3].trim().length() > 0) {
                    groups = parts[3].split(",");
                }
                Recipe recipe = new Recipe(name, ingredients, results, groups);
                this.add(recipe);
            }
            CauldronCookbook cauldronCookbook = this;
            return cauldronCookbook;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    private List<Integer> parseCauldronItems(String list) {
        String[] parts = list.split(",");
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String part : parts) {
            int multiplier = 1;
            try {
                if (part.matches("^.*\\*([0-9]+)$")) {
                    int at = part.lastIndexOf("*");
                    multiplier = Integer.parseInt(part.substring(at + 1, part.length()));
                    part = part.substring(0, at);
                }
                try {
                    for (int i = 0; i < multiplier; ++i) {
                        out.add(Integer.valueOf(part));
                    }
                }
                catch (NumberFormatException e) {
                    log.log(Level.WARNING, "Cauldron: Unknown item " + part);
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Cauldron: Bad multiplier in '" + part + "'");
            }
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Recipe {
        private final String name;
        private final List<Integer> ingredients;
        private final Map<Integer, Integer> ingredientLookup = new HashMap<Integer, Integer>();
        private final List<Integer> results;
        private final String[] groups;

        public Recipe(String name, List<Integer> ingredients, List<Integer> results, String[] groups) {
            this.name = name;
            this.ingredients = Collections.unmodifiableList(ingredients);
            this.results = Collections.unmodifiableList(results);
            this.groups = groups;
            for (Integer id : ingredients) {
                if (this.ingredientLookup.containsKey(id)) {
                    this.ingredientLookup.put(id, this.ingredientLookup.get(id) + 1);
                    continue;
                }
                this.ingredientLookup.put(id, 1);
            }
        }

        public String getName() {
            return this.name;
        }

        public List<Integer> getIngredients() {
            return this.ingredients;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public boolean hasAllIngredients(Map<Integer, Integer> check) {
            for (Map.Entry<Integer, Integer> entry : this.ingredientLookup.entrySet()) {
                int id = entry.getKey();
                if (!check.containsKey(id)) {
                    return false;
                }
                if (check.get(id) >= entry.getValue()) continue;
                return false;
            }
            return true;
        }

        public List<Integer> getResults() {
            return this.results;
        }
    }
}

