/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.LocationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet40EntityMetadata;
import net.minecraft.server.WatchableObject;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;

public class Chair
implements Listener {
    private MechanismsPlugin plugin;
    private Map<String, Block> chairs = new HashMap<String, Block>();

    public Chair(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.chairs = plugin.getLocalConfiguration().chairSettings.chairs;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.getLocalConfiguration().chairSettings.enable) {
            return;
        }
        if (this.chairs.containsValue(event.getBlock())) {
            for (Map.Entry<String, Block> e : this.chairs.entrySet()) {
                if (e.getValue() != event.getBlock()) continue;
                Player p = this.plugin.getServer().getPlayer(e.getKey());
                Packet40EntityMetadata packet = new Packet40EntityMetadata(p.getEntityId(), (DataWatcher)new ChairWatcher(0));
                for (Player play : LocationUtil.getNearbyPlayers((Block)event.getBlock(), (int)(this.plugin.getServer().getViewDistance() * 16))) {
                    ((CraftPlayer)play).getHandle().netServerHandler.sendPacket((Packet)packet);
                }
                this.chairs.remove(p.getName());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerToggleSprint(PlayerToggleSprintEvent event) {
        if (this.chairs.containsKey(event.getPlayer().getName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (this.chairs.containsKey(event.getPlayer().getName())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.chairs.containsKey(event.getPlayer().getName())) {
            this.chairs.remove(event.getPlayer().getName());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().chairSettings.enable) {
            return;
        }
        if (event.getClickedBlock() == null || !this.plugin.getLocalConfiguration().chairSettings.canUseBlock(event.getClickedBlock().getType())) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer((BaseBukkitPlugin)this.plugin, event.getPlayer());
        if (player.getPlayer().getItemInHand() == null || !player.getPlayer().getItemInHand().getType().isBlock() || player.getPlayer().getItemInHand().getTypeId() == 0) {
            if (this.plugin.getLocalConfiguration().chairSettings.requireSneak && !player.getPlayer().isSneaking()) {
                return;
            }
            if (!player.hasPermission("craftbook.mech.chair.use")) {
                player.printError("mech.use-permission");
                return;
            }
            if (this.chairs.containsKey(player.getPlayer().getName())) {
                Packet40EntityMetadata packet = new Packet40EntityMetadata(player.getPlayer().getEntityId(), (DataWatcher)new ChairWatcher(0));
                for (Player play : LocationUtil.getNearbyPlayers((Block)event.getClickedBlock(), (int)(this.plugin.getServer().getViewDistance() * 16))) {
                    ((CraftPlayer)play).getHandle().netServerHandler.sendPacket((Packet)packet);
                }
                this.chairs.remove(player.getPlayer().getName());
            } else {
                if (this.chairs.containsValue(event.getClickedBlock())) {
                    return;
                }
                player.getPlayer().teleport(event.getClickedBlock().getLocation().add(0.5, 0.0, 0.5));
                Packet40EntityMetadata packet = new Packet40EntityMetadata(player.getPlayer().getEntityId(), (DataWatcher)new ChairWatcher(4));
                for (Player play : LocationUtil.getNearbyPlayers((Block)event.getClickedBlock(), (int)(this.plugin.getServer().getViewDistance() * 16))) {
                    ((CraftPlayer)play).getHandle().netServerHandler.sendPacket((Packet)packet);
                }
                this.chairs.put(player.getPlayer().getName(), event.getClickedBlock());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (this.chairs.containsKey(event.getPlayer().getName()) && this.chairs.get(event.getPlayer().getName()).getLocation().add(0.5, 0.0, 0.5).distance(event.getTo()) > 1.0) {
            Location loc = this.chairs.get(event.getPlayer().getName()).getLocation().add(0.5, 0.0, 0.5);
            loc.setPitch(event.getPlayer().getLocation().getPitch());
            loc.setYaw(event.getPlayer().getLocation().getYaw());
            event.getPlayer().teleport(loc);
            event.setCancelled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChairWatcher
    extends DataWatcher {
        private byte metadata;

        public ChairWatcher(byte metadata) {
            this.metadata = metadata;
        }

        public ArrayList<WatchableObject> b() {
            ArrayList<WatchableObject> list = new ArrayList<WatchableObject>();
            WatchableObject wo = new WatchableObject(0, 0, (Object)this.metadata);
            list.add(wo);
            return list;
        }
    }
}

