/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkAnchor
extends PersistentMechanic {
    private final Block trigger;

    private ChunkAnchor(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        this.trigger = trigger;
    }

    public void onRightClick(PlayerInteractEvent event) {
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
    }

    public void unload() {
    }

    public boolean isActive() {
        return true;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public List<BlockWorldVector> getWatchedPositions() {
        return Arrays.asList(BukkitUtil.toWorldVector((Block)this.trigger));
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
        if (event.getChunk().equals(this.trigger.getWorld().getChunkAt(this.trigger))) {
            event.setCancelled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<ChunkAnchor> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public ChunkAnchor detect(BlockWorldVector pt) throws InvalidMechanismException {
            Sign s;
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getState() instanceof Sign && (s = (Sign)block.getState()).getLine(1).equalsIgnoreCase("[Chunk]")) {
                return new ChunkAnchor(block, this.plugin);
            }
            return null;
        }

        public ChunkAnchor detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!sign.getLine(1).equalsIgnoreCase("[Chunk]")) {
                return null;
            }
            if (!player.hasPermission("craftbook.mech.chunk")) {
                throw new InsufficientPermissionsException();
            }
            player.print("Chunk Anchor created.");
            sign.setLine(1, "[Chunk]");
            throw new ProcessedMechanismException();
        }
    }
}

