/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Command
extends AbstractMechanic {
    private final MechanismsPlugin plugin;
    private final Block trigger;

    private Command(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        this.trigger = trigger;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().commandSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.command.use")) {
            localPlayer.printError("mech.use-permission");
            return;
        }
        Sign s = (Sign)event.getClickedBlock().getState();
        if (s.getLine(2).startsWith("/")) {
            event.getPlayer().chat(s.getLine(2) + s.getLine(3));
        } else {
            event.getPlayer().chat("/" + s.getLine(2) + s.getLine(3));
        }
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Command> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Command detect(BlockWorldVector pt) throws InvalidMechanismException {
            Sign s;
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getState() instanceof Sign && (s = (Sign)block.getState()).getLine(1).equalsIgnoreCase("[Command]")) {
                return new Command(block, this.plugin);
            }
            return null;
        }

        public Command detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!sign.getLine(1).equalsIgnoreCase("[Command]")) {
                return null;
            }
            if (!player.hasPermission("craftbook.mech.command")) {
                throw new InsufficientPermissionsException();
            }
            player.print("mech.command.create");
            sign.setLine(1, "[Command]");
            throw new ProcessedMechanismException();
        }
    }
}

