/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SelfTriggeringMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookingPot
extends PersistentMechanic
implements SelfTriggeringMechanic {
    protected final MechanismsPlugin plugin;
    protected final BlockWorldVector pt;

    public CookingPot(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.pt = pt;
        this.plugin = plugin;
    }

    public void unload() {
    }

    public boolean isActive() {
        return true;
    }

    public void think() {
        Block block = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            int lastTick = 0;
            try {
                lastTick = Integer.parseInt(sign.getLine(2));
            }
            catch (Exception e) {
                sign.setLine(2, lastTick + "");
                sign.update();
            }
            int oldTick = lastTick++;
            Block b = SignUtil.getBackBlock((Block)sign.getBlock());
            int x = b.getX();
            int y = b.getY() + 2;
            int z = b.getZ();
            Block cb = sign.getWorld().getBlockAt(x, y, z);
            if (cb.getType() == Material.CHEST) {
                Block fire;
                if (ItemUtil.containsRawFood((Inventory)((Chest)cb.getState()).getInventory())) {
                    // empty if block
                }
                if (lastTick >= 50 && (fire = sign.getWorld().getBlockAt(x, y - 1, z)).getType() == Material.FIRE && cb.getState() instanceof Chest) {
                    Chest chest = (Chest)cb.getState();
                    for (ItemStack i : chest.getInventory().getContents()) {
                        ItemStack cooked;
                        if (i == null || (cooked = ItemUtil.getCookedResult((ItemStack)i)) == null) continue;
                        chest.getInventory().addItem(new ItemStack[]{new ItemStack(cooked.getType(), 1)});
                        chest.getInventory().removeItem(new ItemStack[]{new ItemStack(i.getType(), 1)});
                        chest.update();
                        break;
                    }
                    lastTick = 0;
                }
            }
            if (lastTick != oldTick) {
                sign.setLine(2, lastTick + "");
                sign.update();
            }
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (event.getClickedBlock().getState() instanceof Sign) {
            Sign sign = (Sign)event.getClickedBlock().getState();
            Block b = SignUtil.getBackBlock((Block)sign.getBlock());
            int x = b.getX();
            int y = b.getY() + 2;
            int z = b.getZ();
            Block cb = sign.getWorld().getBlockAt(x, y, z);
            if (cb.getType() == Material.CHEST) {
                event.getPlayer().openInventory(((Chest)cb.getState()).getBlockInventory());
            }
            this.think();
        }
    }

    public void onLeftClick(PlayerInteractEvent event) {
        event.getPlayer().setFireTicks(20);
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        player.printError("mech.cook.ouch");
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public List<BlockWorldVector> getWatchedPositions() {
        ArrayList<BlockWorldVector> bwv = new ArrayList<BlockWorldVector>();
        Block block = BukkitUtil.toWorld((WorldVector)this.pt).getBlockAt(BukkitUtil.toLocation((WorldVector)this.pt));
        bwv.add(this.pt);
        if (block.getState() instanceof Sign) {
            Sign sign = (Sign)block.getState();
            Block b = SignUtil.getBackBlock((Block)sign.getBlock());
            int x = b.getX();
            int y = b.getY() + 2;
            int z = b.getZ();
            bwv.add(BukkitUtil.toWorldVector((Block)b));
            Block cb = sign.getWorld().getBlockAt(x, y, z);
            if (cb.getType() == Material.CHEST) {
                bwv.add(BukkitUtil.toWorldVector((Block)cb));
                Block fire = sign.getWorld().getBlockAt(x, y - 1, z);
                if (fire.getType() == Material.FIRE) {
                    bwv.add(BukkitUtil.toWorldVector((Block)fire));
                }
            }
        }
        return bwv;
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<CookingPot> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public CookingPot detect(BlockWorldVector pt) {
            Sign sign;
            BlockState state;
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign && (sign = (Sign)state).getLine(1).equalsIgnoreCase("[Cook]")) {
                sign.setLine(2, "0");
                sign.update();
                return new CookingPot(pt, this.plugin);
            }
            return null;
        }

        public CookingPot detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Cook]")) {
                if (!player.hasPermission("craftbook.mech.cook")) {
                    throw new InsufficientPermissionsException();
                }
            } else {
                return null;
            }
            sign.setLine(2, "0");
            sign.setLine(1, "[Cook]");
            sign.update();
            player.print("mech.cook.create");
            throw new ProcessedMechanismException();
        }
    }
}

