/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.CustomDropManager;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class CustomDrops
extends MechanismsPlugin
implements Listener {
    final MechanismsPlugin plugin;

    public CustomDrops(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void handleCustomBlockDrops(BlockBreakEvent event) {
        CustomDropManager.DropDefinition[] drops;
        if (this.plugin.getLocalConfiguration().customDropSettings.requirePermissions && !this.plugin.wrap(event.getPlayer()).hasPermission("craftbook.mech.drops")) {
            return;
        }
        int id = event.getBlock().getTypeId();
        byte data = event.getBlock().getData();
        CustomDropManager.CustomItemDrop drop = this.plugin.getLocalConfiguration().customDrops.getBlockDrops(id);
        if (drop != null && (drops = drop.getDrop(data)) != null) {
            Location l = event.getBlock().getLocation();
            World w = event.getBlock().getWorld();
            for (CustomDropManager.DropDefinition dropDefinition : drops) {
                w.dropItemNaturally(l, dropDefinition.getItemStack());
            }
            event.getBlock().breakNaturally(null);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void handleCustomMobDrops(EntityDeathEvent event) {
        EntityType entityType = event.getEntityType();
        if (entityType == null || !entityType.isAlive() || entityType.equals((Object)EntityType.PLAYER)) {
            return;
        }
        CustomDropManager.DropDefinition[] drops = this.plugin.getLocalConfiguration().customDrops.getMobDrop(entityType.getName());
        if (drops != null) {
            event.getDrops().clear();
            for (CustomDropManager.DropDefinition dropDefinition : drops) {
                event.getDrops().add(dropDefinition.getItemStack());
            }
        }
    }
}

