/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Elevator
extends AbstractMechanic {
    private final MechanismsPlugin plugin;
    private final Block trigger;
    private final BlockFace shift;
    private Block destination;

    private Elevator(Block trigger, Direction dir, MechanismsPlugin plugin) throws InvalidMechanismException {
        block2: {
            this.trigger = trigger;
            this.plugin = plugin;
            this.shift = dir == Direction.UP ? BlockFace.UP : BlockFace.DOWN;
            int f = dir == Direction.UP ? trigger.getWorld().getMaxHeight() : 0;
            this.destination = trigger;
            if (this.destination.getY() == f) {
                throw new InvalidConstructionException();
            }
            do {
                this.destination = this.destination.getRelative(this.shift);
                Direction derp = Elevator.isLift(this.destination);
                if (derp != Direction.NONE) break block2;
                if (this.destination.getY() != trigger.getWorld().getMaxHeight()) continue;
                throw new InvalidConstructionException();
            } while (this.destination.getY() != 0);
            throw new InvalidConstructionException();
        }
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().elevatorSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.elevator.use")) {
            localPlayer.printError("mech.use-permission");
            return;
        }
        this.makeItSo(event.getPlayer());
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
    }

    private void makeItSo(Player player) {
        Block floor = this.destination.getWorld().getBlockAt((int)Math.floor(player.getLocation().getX()), this.destination.getY() + 1, (int)Math.floor(player.getLocation().getZ()));
        if (!Elevator.occupiable(floor)) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        LocalPlayer local = this.plugin.wrap(player);
        int foundFree = 0;
        boolean foundGround = false;
        for (int i = 0; i < 5; ++i) {
            if (Elevator.occupiable(floor)) {
                ++foundFree;
            } else {
                foundGround = true;
                break;
            }
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (!foundGround) {
            local.printError("mech.lift.no-floor");
            return;
        }
        if (foundFree < 2) {
            local.printError("mech.lift.obstruct");
            return;
        }
        Location subspaceRift = player.getLocation().clone();
        subspaceRift.setY((double)(floor.getY() + 1));
        if (player.isInsideVehicle()) {
            subspaceRift = player.getVehicle().getLocation().clone();
            subspaceRift.setY((double)(floor.getY() + 2));
            player.getVehicle().teleport(subspaceRift);
        }
        player.teleport(subspaceRift);
        String title = ((Sign)this.destination.getState()).getLines()[0];
        if (title.length() != 0) {
            player.sendMessage("Floor: " + title);
        } else {
            player.sendMessage("You went " + (this.shift.getModY() > 0 ? "up" : "down") + " a floor.");
        }
    }

    private static Direction isLift(Block block) {
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return Direction.NONE;
        }
        return Elevator.isLift((Sign)state);
    }

    private static Direction isLift(Sign sign) {
        if (sign.getLines()[1].equalsIgnoreCase("[Lift Up]")) {
            return Direction.UP;
        }
        if (sign.getLines()[1].equalsIgnoreCase("[Lift Down]")) {
            return Direction.DOWN;
        }
        if (sign.getLines()[1].equalsIgnoreCase("[Lift]")) {
            return Direction.RECV;
        }
        return Direction.NONE;
    }

    private static boolean occupiable(Block block) {
        return BlockType.canPassThrough((int)block.getTypeId());
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 2306504048848430689L;

        public InvalidConstructionException() {
            super("This lift has no destination.");
        }
    }

    private static class NoDepartureException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 3845311158458450314L;

        public NoDepartureException() {
            super("Cannot depart from this lift (can only arrive).");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        NONE,
        UP,
        DOWN,
        RECV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Elevator> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Elevator detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            Direction dir = Elevator.isLift(block);
            switch (dir) {
                case UP: 
                case DOWN: {
                    return new Elevator(block, dir, this.plugin);
                }
                case RECV: {
                    throw new NoDepartureException();
                }
            }
            return null;
        }

        public Elevator detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            Direction dir = Elevator.isLift(sign);
            switch (dir) {
                case UP: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.up-sign-created");
                    sign.setLine(1, "[Lift Up]");
                    break;
                }
                case DOWN: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.down-sign-created");
                    sign.setLine(1, "[Lift Down]");
                    break;
                }
                case RECV: {
                    player.checkPermission("craftbook.mech.elevator");
                    player.print("mech.lift.target-sign-created");
                    sign.setLine(1, "[Lift]");
                    break;
                }
                default: {
                    return null;
                }
            }
            throw new ProcessedMechanismException();
        }
    }
}

