/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class HiddenSwitch
extends AbstractMechanic {
    final Block switchBlock;
    final MechanismsPlugin plugin;

    public HiddenSwitch(Block block, MechanismsPlugin plugin) {
        this.switchBlock = block;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        Sign s;
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        try {
            player.checkPermission("craftbook.mech.hiddenswitch.use");
        }
        catch (InsufficientPermissionsException e) {
            return;
        }
        if (event.getBlockFace() != BlockFace.EAST && event.getBlockFace() != BlockFace.WEST && event.getBlockFace() != BlockFace.NORTH && event.getBlockFace() != BlockFace.SOUTH) {
            return;
        }
        Block testBlock = this.switchBlock.getRelative(event.getBlockFace().getOppositeFace());
        if (testBlock.getType() == Material.WALL_SIGN && (s = (Sign)testBlock.getState()).getLine(1).equalsIgnoreCase("[X]")) {
            int itemID = -1;
            if (!s.getLine(0).trim().equalsIgnoreCase("")) {
                try {
                    itemID = Integer.parseInt(s.getLine(0).trim());
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (!s.getLine(2).trim().equalsIgnoreCase("") && !this.plugin.isInGroup(event.getPlayer().getName(), s.getLine(2).trim())) {
                player.printError("mech.group");
                return;
            }
            if (itemID == -1) {
                this.toggleSwitches(testBlock, event.getBlockFace().getOppositeFace());
            } else if (event.getPlayer().getItemInHand() != null || itemID == 0) {
                if (itemID == 0 && event.getPlayer().getItemInHand() == null || event.getPlayer().getItemInHand().getTypeId() == itemID) {
                    this.toggleSwitches(testBlock, event.getBlockFace().getOppositeFace());
                } else {
                    player.printError("mech.hiddenswitch.key");
                }
            } else {
                player.printError("mech.hiddenswitch.key");
            }
        }
    }

    private void toggleSwitches(Block sign, BlockFace direction) {
        BlockFace[] checkFaces = new BlockFace[4];
        checkFaces[0] = BlockFace.UP;
        checkFaces[1] = BlockFace.DOWN;
        switch (direction) {
            case EAST: 
            case WEST: {
                checkFaces[2] = BlockFace.NORTH;
                checkFaces[3] = BlockFace.SOUTH;
                break;
            }
            default: {
                checkFaces[2] = BlockFace.EAST;
                checkFaces[3] = BlockFace.WEST;
            }
        }
        for (BlockFace blockFace : checkFaces) {
            Block checkBlock = sign.getRelative(blockFace);
            if (checkBlock.getTypeId() != 69) continue;
            checkBlock.setData((byte)(checkBlock.getData() ^ 8));
        }
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<HiddenSwitch> {
        final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public HiddenSwitch detect(BlockWorldVector pos, LocalPlayer player, Sign sign) throws InvalidMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[X]")) {
                player.checkPermission("craftbook.mech.hiddenswitch");
                return new HiddenSwitch(BukkitUtil.toBlock((BlockWorldVector)pos), this.plugin);
            }
            return null;
        }

        private boolean isValidWallSign(World world, Vector v) {
            Block b = world.getBlockAt(v.getBlockX(), v.getBlockY(), v.getBlockZ());
            if (b == null || b.getTypeId() != 68) {
                return false;
            }
            if (!(b.getState() instanceof Sign)) {
                return false;
            }
            Sign s = (Sign)b.getState();
            return s.getLine(1).equalsIgnoreCase("[X]");
        }

        public HiddenSwitch detect(BlockWorldVector pos) throws InvalidMechanismException {
            World wrd = BukkitUtil.toWorld((WorldVector)pos);
            if (this.isValidWallSign(wrd, pos.add(1, 0, 0)) || this.isValidWallSign(wrd, pos.add(-1, 0, 0)) || this.isValidWallSign(wrd, pos.add(0, 0, 1)) || this.isValidWallSign(wrd, pos.add(0, 0, -1))) {
                return new HiddenSwitch(BukkitUtil.toBlock((BlockWorldVector)pos), this.plugin);
            }
            return null;
        }
    }
}

