/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class LightStone
extends AbstractMechanic {
    protected final MechanismsPlugin plugin;

    public LightStone(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!player.hasPermission("craftbook.mech.lightstone.use")) {
            return;
        }
        Block block = event.getClickedBlock().getRelative(event.getBlockFace());
        if (event.getPlayer().getItemInHand().getTypeId() == 348) {
            String lightLevelLine = this.getLightLine(block.getLightLevel());
            player.print(ChatColor.YELLOW + "LightStone: [" + lightLevelLine + ChatColor.YELLOW + "] " + block.getLightLevel() + " L");
        }
    }

    private String getLightLine(int data) {
        int i;
        String line = "";
        line = data >= 9 ? line + ChatColor.GREEN : line + ChatColor.DARK_RED;
        for (i = 0; i < data; ++i) {
            line = line + "|";
        }
        line = line + ChatColor.BLACK;
        for (i = data; i < 15; ++i) {
            line = line + "|";
        }
        return line;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<LightStone> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public LightStone detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (block != null) {
                return new LightStone(this.plugin);
            }
            return null;
        }
    }
}

