/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.HistoryHashMap;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class LightSwitch
extends AbstractMechanic {
    private final HistoryHashMap<BlockWorldVector, Long> recentLightToggles = new HistoryHashMap(20);
    protected final MechanismsPlugin plugin;
    private final BlockWorldVector pt;

    private LightSwitch(BlockWorldVector pt, MechanismsPlugin plugin) {
        this.pt = pt;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().lightSwitchSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)this.pt)) {
            return;
        }
        this.toggleLights(this.pt);
    }

    private boolean toggleLights(BlockWorldVector pt) {
        int wz;
        int wy;
        int wx;
        int aboveID;
        World world = BukkitUtil.toWorld((WorldVector)pt);
        Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
        if (block.getTypeId() != 68) {
            return false;
        }
        int radius = 10;
        int maximum = 20;
        try {
            radius = Integer.parseInt(((Sign)block.getState()).getLine(2));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            maximum = Integer.parseInt(((Sign)block.getState()).getLine(3));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (radius > this.plugin.getLocalConfiguration().lightSwitchSettings.maxRange) {
            radius = this.plugin.getLocalConfiguration().lightSwitchSettings.maxRange;
        }
        if (maximum > this.plugin.getLocalConfiguration().lightSwitchSettings.maxMaximum) {
            maximum = this.plugin.getLocalConfiguration().lightSwitchSettings.maxMaximum;
        }
        if ((aboveID = world.getBlockTypeIdAt(wx = pt.getBlockX(), (wy = pt.getBlockY()) + 1, wz = pt.getBlockZ())) == 50 || aboveID == 75 || aboveID == 76) {
            boolean on = aboveID != 50;
            Long lastUse = (Long)this.recentLightToggles.remove((Object)pt);
            long currTime = System.currentTimeMillis();
            if (lastUse != null && currTime - lastUse < 500L) {
                this.recentLightToggles.put((Object)pt, (Object)lastUse);
                return true;
            }
            this.recentLightToggles.put((Object)pt, (Object)currTime);
            int changed = 0;
            for (int x = -radius + wx; x <= radius + wx; ++x) {
                for (int y = -radius + wy; y <= radius + wy; ++y) {
                    for (int z = -radius + wz; z <= radius + wz; ++z) {
                        int id = world.getBlockTypeIdAt(x, y, z);
                        if (id != 50 && id != 75 && id != 76) continue;
                        if (changed >= maximum) {
                            return true;
                        }
                        if (on) {
                            world.getBlockAt(x, y, z).setTypeId(50);
                        } else {
                            world.getBlockAt(x, y, z).setTypeId(76);
                        }
                        ++changed;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<LightSwitch> {
        protected final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public LightSwitch detect(BlockWorldVector pt) {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 68) {
                return null;
            }
            String line = ((Sign)block.getState()).getLine(1);
            if (!line.equalsIgnoreCase("[|]") && !line.equalsIgnoreCase("[I]")) {
                return null;
            }
            return new LightSwitch(pt, this.plugin);
        }

        public LightSwitch detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            String line = sign.getLine(1);
            if (line.equalsIgnoreCase("[|]") || line.equalsIgnoreCase("[I]")) {
                if (!player.hasPermission("craftbook.mech.light-switch")) {
                    throw new InsufficientPermissionsException();
                }
            } else {
                return null;
            }
            sign.setLine(1, "[I]");
            player.print("Light switch created.");
            throw new ProcessedMechanismException();
        }
    }
}

