/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import java.util.HashMap;
import org.bukkit.Art;
import org.bukkit.entity.Painting;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;

public class PaintingSwitch
implements Listener {
    MechanismsPlugin plugin;
    HashMap<Painting, String> paintings = new HashMap();
    HashMap<String, Painting> players = new HashMap();

    public PaintingSwitch(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Painting) {
            if (!this.plugin.getLocalConfiguration().paintingSettings.enabled) {
                return;
            }
            Painting paint = (Painting)event.getRightClicked();
            if (event.getPlayer().hasPermission("craftbook.mech.paintingswitch.use")) {
                if (this.paintings.get(paint) == null || this.plugin.getServer().getPlayer(this.paintings.get(paint)) == null) {
                    this.paintings.put(paint, event.getPlayer().getName());
                    this.players.put(event.getPlayer().getName(), paint);
                    event.getPlayer().sendMessage("You are now editing the painting!");
                    event.setCancelled(true);
                } else if (this.paintings.get(paint).equalsIgnoreCase(event.getPlayer().getName())) {
                    this.paintings.remove(paint);
                    this.players.remove(event.getPlayer().getName());
                    event.getPlayer().sendMessage("You are no longer editing the painting!");
                    event.setCancelled(true);
                } else if (this.paintings.get(paint) != null && this.plugin.getServer().getPlayer(this.paintings.get(paint)) != null) {
                    event.getPlayer().sendMessage("The painting is already being edited by " + this.paintings.get(paint) + "!");
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHeldItemChange(PlayerItemHeldEvent event) {
        if (!this.plugin.getLocalConfiguration().paintingSettings.enabled) {
            return;
        }
        if (!event.getPlayer().hasPermission("craftbook.mech.paintingswitch.use")) {
            return;
        }
        if (this.players.get(event.getPlayer().getName()) == null || this.players.get(event.getPlayer().getName()).isDead()) {
            try {
                this.paintings.remove(this.players.get(event.getPlayer().getName()));
                this.players.remove(event.getPlayer().getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        boolean isForwards = false;
        if (event.getNewSlot() > event.getPreviousSlot()) {
            isForwards = true;
        } else if (event.getNewSlot() < event.getPreviousSlot()) {
            isForwards = false;
        } else {
            return;
        }
        if (event.getPreviousSlot() < 1 && event.getNewSlot() > 8) {
            isForwards = false;
        } else if (event.getPreviousSlot() > 8 && event.getNewSlot() < 1) {
            isForwards = true;
        }
        Art[] art = Art.values();
        Painting paint = this.players.get(event.getPlayer().getName());
        int newID = paint.getArt().getId() + (isForwards ? -1 : 1);
        if (newID < 0) {
            newID = art.length - 1;
        }
        if (newID >= art.length) {
            newID = 0;
        }
        paint.setArt(art[newID]);
    }
}

