/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class Snow
implements Listener {
    final MechanismsPlugin plugin;

    public Snow(MechanismsPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.placeSnow) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.snow.place")) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        try {
            if (event.getPlayer().getItemInHand().getTypeId() == 332 && event.getClickedBlock().getTypeId() == 78) {
                if (event.getClickedBlock().getData() < 7) {
                    this.incrementData(event.getClickedBlock());
                }
            } else if (event.getPlayer().getItemInHand().getTypeId() == 332 && event.getPlayer().getWorld().getBlockAt(event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0)).getTypeId() == 0) {
                event.getPlayer().getWorld().getBlockAt(event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0)).setTypeId(78);
                this.incrementData(event.getPlayer().getWorld().getBlockAt(event.getClickedBlock().getLocation().add(0.0, 1.0, 0.0)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getLocalConfiguration().snowSettings.trample) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (!player.hasPermission("craftbook.mech.snow.trample")) {
            return;
        }
        Random random = new Random();
        if (this.plugin.getLocalConfiguration().snowSettings.jumpTrample && event.getPlayer().getVelocity().getY() >= 0.0) {
            return;
        }
        if (random.nextInt(10) == 6) {
            Block b = event.getPlayer().getWorld().getBlockAt(event.getPlayer().getLocation());
            if (b.getTypeId() == 78) {
                this.lowerData(b);
            }
            if ((b = event.getPlayer().getWorld().getBlockAt(event.getPlayer().getLocation().subtract(0.0, 1.0, 0.0))).getTypeId() == 78) {
                this.lowerData(b);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockForm(BlockFormEvent event) {
        Block block;
        if (!this.plugin.getLocalConfiguration().snowSettings.enable) {
            return;
        }
        if (event.getNewState().getTypeId() == 78 && (block = event.getBlock()).getTypeId() != 80 && block.getTypeId() != 78) {
            Location blockLoc = block.getLocation().subtract(0.0, 1.0, 0.0);
            if (block.getWorld().getBlockAt(blockLoc).getTypeId() == 80 && !this.plugin.getLocalConfiguration().snowSettings.piling || block.getWorld().getBlockAt(blockLoc).getTypeId() == 78) {
                return;
            }
            Random random = new Random();
            long delay = random.nextInt(100) + 60;
            if (this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new makeSnow(block.getLocation()), delay * 20L) == -1) {
                this.plugin.getLogger().log(Level.SEVERE, "[CraftBookMechanisms] Snow Mechanic failed to schedule!");
            }
        }
    }

    public void lowerData(Block block) {
        byte newData = (byte)(block.getData() - 1);
        if (newData < 1) {
            block.setTypeId(0);
            newData = 0;
        }
        if (block.getTypeId() == 80) {
            block.setTypeId(78);
            newData = 7;
        }
        if (newData > 7) {
            newData = 7;
        }
        this.setBlockDataWithNotify(block, newData);
    }

    public void incrementData(Block block) {
        byte newData = (byte)(block.getData() + 1);
        if (newData > 7 && this.plugin.getLocalConfiguration().snowSettings.piling) {
            block.setTypeId(80);
            newData = 0;
        }
        this.setBlockDataWithNotify(block, newData);
    }

    public void setBlockDataWithNotify(Block block, byte data) {
        block.setData(data);
        for (Player p : block.getWorld().getPlayers()) {
            if (!(p.getLocation().distance(block.getLocation()) < (double)(this.plugin.getServer().getViewDistance() * 16))) continue;
            p.sendBlockChange(block.getLocation(), block.getTypeId(), data);
        }
    }

    public class makeSnow
    implements Runnable {
        final Location event;

        public makeSnow(Location event) {
            this.event = event;
        }

        public void run() {
            if (this.event.getWorld().hasStorm()) {
                if (this.event.getBlock().getData() > 7) {
                    return;
                }
                if (this.event.subtract(0.0, 1.0, 0.0).getBlock().getTypeId() == 0) {
                    return;
                }
                this.event.add(0.0, 1.0, 0.0);
                if (this.event.getBlock().getTypeId() != 78 && this.event.getBlock().getTypeId() != 80) {
                    return;
                }
                Snow.this.incrementData(this.event.getBlock());
                Random random = new Random();
                long delay = random.nextInt(100) + 60;
                if (Snow.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Snow.this.plugin, (Runnable)new makeSnow(this.event), delay * 20L) == -1) {
                    Snow.this.plugin.getLogger().log(Level.SEVERE, "[CraftBookMechanisms] Snow Mechanic failed to schedule!");
                }
            } else {
                Random random = new Random();
                long delay = random.nextInt(100) + 600;
                if (Snow.this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Snow.this.plugin, (Runnable)new makeSnow(this.event), delay * 20L) == -1) {
                    Snow.this.plugin.getLogger().log(Level.SEVERE, "[CraftBookMechanisms] Snow Mechanic failed to schedule!");
                }
            }
        }
    }
}

