/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Teleporter
extends AbstractMechanic {
    private final MechanismsPlugin plugin;
    private final Block trigger;

    private Teleporter(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        this.trigger = trigger;
        this.plugin = plugin;
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().teleporterSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        if (!localPlayer.hasPermission("craftbook.mech.teleporter.use")) {
            localPlayer.printError("mech.use-permission");
            return;
        }
        this.makeItSo(event.getPlayer());
        event.setCancelled(true);
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
    }

    private void makeItSo(Player p) {
        Block floor;
        LocalPlayer player = this.plugin.wrap(p);
        double toX = 0.0;
        double toY = 0.0;
        double toZ = 0.0;
        if (this.trigger.getState() instanceof Sign) {
            Sign s = (Sign)this.trigger.getState();
            String[] pos = s.getLine(2).split(":");
            if (pos.length > 2) {
                try {
                    toX = Double.parseDouble(pos[0]);
                    toY = Double.parseDouble(pos[1]);
                    toZ = Double.parseDouble(pos[2]);
                }
                catch (Exception e) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!Teleporter.occupiable(floor = this.trigger.getWorld().getBlockAt((int)Math.floor(toX), (int)(Math.floor(toY) + 1.0), (int)Math.floor(toZ)))) {
            floor = floor.getRelative(BlockFace.DOWN);
        }
        int foundFree = 0;
        for (int i = 0; i < 5 && Teleporter.occupiable(floor); ++i) {
            ++foundFree;
            if (floor.getY() == 0) break;
            floor = floor.getRelative(BlockFace.DOWN);
        }
        if (foundFree < 2) {
            player.printError("mech.lift.obstruct");
            return;
        }
        Location subspaceRift = p.getLocation().clone();
        subspaceRift.setY((double)(floor.getY() + 1));
        subspaceRift.setX((double)floor.getX());
        subspaceRift.setZ((double)floor.getZ());
        if (p.isInsideVehicle()) {
            subspaceRift = p.getVehicle().getLocation().clone();
            subspaceRift.setY((double)(floor.getY() + 2));
            subspaceRift.setX((double)floor.getX());
            subspaceRift.setZ((double)floor.getZ());
            p.getVehicle().teleport(subspaceRift);
        }
        p.teleport(subspaceRift);
        player.print("mech.teleport.alert");
    }

    private static boolean occupiable(Block block) {
        return BlockType.canPassThrough((int)block.getTypeId());
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Teleporter> {
        private final MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        public Teleporter detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getState() instanceof Sign) {
                Sign s = (Sign)block.getState();
                if (!s.getLine(1).equalsIgnoreCase("[Teleporter]")) {
                    return null;
                }
                String[] pos = s.getLine(2).split(":");
                if (pos.length > 2) {
                    return new Teleporter(block, this.plugin);
                }
            }
            return null;
        }

        public Teleporter detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (!sign.getLine(1).equalsIgnoreCase("[Teleporter]")) {
                return null;
            }
            if (!player.hasPermission("craftbook.mech.teleporter")) {
                throw new InsufficientPermissionsException();
            }
            player.print("mech.teleport.create");
            sign.setLine(1, "[Teleporter]");
            String[] pos = sign.getLine(2).split(":");
            if (pos.length <= 2) {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

