/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.cauldron;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.mech.cauldron.CauldronItemStack;
import com.sk89q.craftbook.mech.cauldron.UnknownRecipeException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedCauldronCookbook
extends BaseConfiguration {
    public static ImprovedCauldronCookbook INSTANCE;
    private final Collection<Recipe> recipes = new ArrayList<Recipe>();
    private final File config;

    public ImprovedCauldronCookbook(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
        this.config = new File(dataFolder, "cauldron-recipes.yml");
        this.load(cfg.getConfigurationSection("cauldron-recipes"));
        INSTANCE = this;
    }

    public void reload() {
        this.recipes.clear();
        this.load(YamlConfiguration.loadConfiguration((File)this.config).getConfigurationSection("cauldron-recipes"));
    }

    private void load(ConfigurationSection cfg) {
        if (cfg == null) {
            return;
        }
        Set keys = cfg.getKeys(false);
        if (keys != null) {
            for (String key : keys) {
                this.recipes.add(new Recipe(key, cfg));
            }
        }
    }

    public Recipe getRecipe(Collection<CauldronItemStack> items) throws UnknownRecipeException {
        for (Recipe recipe : this.recipes) {
            if (!recipe.checkIngredients(items)) continue;
            return recipe;
        }
        throw new UnknownRecipeException("Are you sure you have the right ingredients?");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Recipe {
        private final String id;
        private final ConfigurationSection config;
        private String name;
        private String description;
        private Collection<CauldronItemStack> ingredients;
        private Collection<CauldronItemStack> results;
        private double chance;

        private Recipe(String id, ConfigurationSection cfg) {
            this.id = id;
            this.config = cfg.getConfigurationSection(id);
            this.ingredients = new ArrayList<CauldronItemStack>();
            this.results = new ArrayList<CauldronItemStack>();
            this.chance = 60.0;
            this.load();
        }

        private void load() {
            this.name = this.config.getString("name");
            this.description = this.config.getString("description");
            this.ingredients = this.getItems(this.config.getConfigurationSection("ingredients"));
            this.results = this.getItems(this.config.getConfigurationSection("results"));
            this.chance = this.config.getDouble("chance", 60.0);
        }

        private Collection<CauldronItemStack> getItems(ConfigurationSection section) {
            ArrayList<CauldronItemStack> items = new ArrayList<CauldronItemStack>();
            for (String item : section.getKeys(false)) {
                Material material;
                String[] split = item.split(":");
                try {
                    material = Material.getMaterial((int)Integer.parseInt(split[0]));
                }
                catch (NumberFormatException e) {
                    material = Material.getMaterial((String)split[0].toUpperCase());
                }
                if (material == null) continue;
                CauldronItemStack itemStack = new CauldronItemStack(material);
                if (split.length > 1) {
                    itemStack.setData(Short.parseShort(split[1]));
                } else {
                    itemStack.setData((short)-1);
                }
                itemStack.setAmount(section.getInt(item, 1));
                items.add(itemStack);
            }
            return items;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public double getChance() {
            return this.chance;
        }

        public boolean checkIngredients(Collection<CauldronItemStack> items) {
            if (items.size() <= 0) {
                return false;
            }
            int count = 0;
            for (CauldronItemStack item : items) {
                if (!this.ingredients.contains(item)) {
                    return false;
                }
                ++count;
            }
            return count == this.ingredients.size();
        }

        public Collection<CauldronItemStack> getResults() {
            return this.results;
        }
    }
}

