/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.crafting;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.crafting.CraftingItemStack;
import com.sk89q.craftbook.mech.crafting.RecipeManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class CustomCrafting {
    protected final RecipeManager recipes;
    protected final MechanismsPlugin plugin;
    HashMap<Integer, Character> numberLetter = new HashMap();

    public CustomCrafting(MechanismsPlugin plugin) {
        this.numberLetter.put(1, Character.valueOf('a'));
        this.numberLetter.put(2, Character.valueOf('b'));
        this.numberLetter.put(3, Character.valueOf('c'));
        this.numberLetter.put(4, Character.valueOf('d'));
        this.numberLetter.put(5, Character.valueOf('e'));
        this.numberLetter.put(6, Character.valueOf('f'));
        this.numberLetter.put(7, Character.valueOf('g'));
        this.numberLetter.put(8, Character.valueOf('h'));
        this.numberLetter.put(9, Character.valueOf('i'));
        this.plugin = plugin;
        this.recipes = new RecipeManager((FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "crafting-recipes.yml")), plugin.getDataFolder());
        Collection<RecipeManager.Recipe> recipeCollection = this.recipes.getRecipes();
        for (RecipeManager.Recipe r : recipeCollection) {
            ShapelessRecipe sh;
            if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPELESS) {
                sh = new ShapelessRecipe(r.getResult().getItemStack());
                for (CraftingItemStack is : r.getIngredients()) {
                    sh.addIngredient(is.getMaterial(), (int)is.getData());
                }
                plugin.getServer().addRecipe((Recipe)sh);
                continue;
            }
            if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPED2X2) {
                sh = new ShapedRecipe(r.getResult().getItemStack());
                sh.shape(new String[]{"ab", "cd"});
                int ingredientNum = 0;
                for (CraftingItemStack is : r.getIngredients()) {
                    sh.setIngredient(this.numberLetter.get(++ingredientNum).charValue(), is.getMaterial(), (int)is.getData());
                }
                plugin.getServer().addRecipe((Recipe)sh);
                continue;
            }
            if (r.getType() == RecipeManager.Recipe.RecipeType.SHAPED3X3) {
                sh = new ShapedRecipe(r.getResult().getItemStack());
                sh.shape(new String[]{"abc", "def", "ghi"});
                int ingredientNum = 0;
                for (CraftingItemStack is : r.getIngredients()) {
                    sh.setIngredient(this.numberLetter.get(++ingredientNum).charValue(), is.getMaterial(), (int)is.getData());
                }
                plugin.getServer().addRecipe((Recipe)sh);
                continue;
            }
            if (r.getType() != RecipeManager.Recipe.RecipeType.FURNACE) continue;
            sh = new FurnaceRecipe(r.getResult().getItemStack(), r.getResult().getMaterial());
            plugin.getServer().addRecipe((Recipe)sh);
        }
    }
}

